"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogsClient = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createLogsClient = async resources => {
  const {
    context
  } = resources;
  const core = await context.core;
  const {
    savedObjects
  } = core;
  const logsDataAccess = await resources.plugins.logsDataAccess.start();
  const logSourcesService = await logsDataAccess.services.logSourcesServiceFactory.getLogSourcesService(savedObjects.client);
  const [logsIndexPattern, esClient] = await Promise.all([logSourcesService.getFlattenedLogSources(), core.elasticsearch.client.asCurrentUser]);
  async function search(props) {
    const response = await esClient.search({
      index: logsIndexPattern,
      size: 1000,
      track_total_hits: false,
      query: props.query,
      fields: props.fields
    });
    return response;
  }
  return {
    search
  };
};
exports.createLogsClient = createLogsClient;