"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentConfigurationTable = AgentConfigurationTable;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _get_apm_agent_commands = require("./commands/get_apm_agent_commands");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/tutorial/config_agent/agent_config_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AgentConfigurationTable({
  variables,
  data
}) {
  if (!variables) return null;
  const columns = [{
    field: 'setting',
    name: _i18n.i18n.translate('xpack.apm.tutorial.agent.column.configSettings', {
      defaultMessage: 'Configuration setting'
    })
  }, {
    field: 'value',
    name: _i18n.i18n.translate('xpack.apm.tutorial.agent.column.configValue', {
      defaultMessage: 'Configuration value'
    }),
    render: (_, {
      value,
      setting
    }) => {
      if (_get_apm_agent_commands.secretTokenKeys.includes(setting) && !!value) return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
        type: "dual",
        value: value !== null && value !== void 0 ? value : '',
        "data-test-subj": "secret_key",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 18
        }
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "accent",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 11
        }
      }, value);
    }
  }];
  const items = Object.keys(variables).map(k => ({
    setting: variables[k],
    value: (0, _lodash.get)(data, k) // TODO do we want default values?
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 10
    }
  });
}