"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProgressiveFetcher = useProgressiveFetcher;
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _use_fetcher = require("./use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function clientWithProbability(regularCallApmApi, probability) {
  return (endpoint, options) => {
    return regularCallApmApi(endpoint, {
      ...options,
      params: {
        ...options.params,
        query: {
          ...options.params.query,
          probability
        }
      }
    });
  };
}
function useProgressiveFetcher(callback, dependencies, options) {
  var _uiSettings$get;
  const {
    services: {
      uiSettings
    }
  } = (0, _public.useKibana)();
  const progressiveLoadingQuality = (_uiSettings$get = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get(_common.apmProgressiveLoading)) !== null && _uiSettings$get !== void 0 ? _uiSettings$get : _common.ProgressiveLoadingQuality.off;
  const sampledProbability = (0, _common.getProbabilityFromProgressiveLoadingQuality)(progressiveLoadingQuality);
  const sampledFetch = (0, _use_fetcher.useFetcher)(regularCallApmApi => {
    if (progressiveLoadingQuality === _common.ProgressiveLoadingQuality.off) {
      return;
    }
    return callback(clientWithProbability(regularCallApmApi, sampledProbability));
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  dependencies, options);
  const unsampledFetch = (0, _use_fetcher.useFetcher)(regularCallApmApi => {
    return callback(clientWithProbability(regularCallApmApi, 1));
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  dependencies);
  const fetches = [unsampledFetch, sampledFetch];
  const isError = unsampledFetch.status === _use_fetcher.FETCH_STATUS.FAILURE;
  const usedFetch = !isError && fetches.find(fetch => fetch.status === _use_fetcher.FETCH_STATUS.SUCCESS) || unsampledFetch;
  const status = unsampledFetch.status === _use_fetcher.FETCH_STATUS.LOADING && usedFetch.status === _use_fetcher.FETCH_STATUS.SUCCESS ? _use_fetcher.FETCH_STATUS.LOADING : usedFetch.status;
  return {
    ...usedFetch,
    status
  };
}