"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccordionWaterfall = AccordionWaterfall;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _polished = require("polished");
var _react = _interopRequireWildcard(require("react"));
var _reactVirtualized = require("react-virtualized");
var _reactWindow = require("react-window");
var _react2 = require("@emotion/react");
var _formatters = require("../../../../../../../common/utils/formatters");
var _waterfall_item = require("./waterfall_item");
var _waterfall_context = require("./context/waterfall_context");
var _use_waterfall = require("./context/use_waterfall");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/waterfall_container/waterfall/accordion_waterfall.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ACCORDION_HEIGHT = 48;
function AccordionWaterfall({
  maxLevelOpen,
  showCriticalPath,
  waterfall,
  isOpen,
  isEmbeddable = false,
  scrollElement,
  ...props
}) {
  return /*#__PURE__*/_react.default.createElement(_waterfall_context.WaterfallContextProvider, {
    maxLevelOpen: maxLevelOpen,
    showCriticalPath: showCriticalPath,
    waterfall: waterfall,
    isOpen: isOpen,
    isEmbeddable: isEmbeddable,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Waterfall, (0, _extends2.default)({}, props, {
    scrollElement: scrollElement,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  })));
}
function Waterfall(props) {
  const listRef = (0, _react.useRef)(null);
  const rowSizeMapRef = (0, _react.useRef)(new Map());
  const {
    traceList
  } = (0, _use_waterfall.useWaterfallContext)();
  const visibleTraceList = props.displayLimit ? traceList.slice(0, props.displayLimit) : traceList;
  const onRowLoad = (index, size) => {
    rowSizeMapRef.current.set(index, size);
  };
  const getRowSize = index => {
    // adds 1px for the border top
    return rowSizeMapRef.current.get(index) || ACCORDION_HEIGHT + 1;
  };
  const onScroll = ({
    scrollTop
  }) => {
    var _listRef$current;
    (_listRef$current = listRef.current) === null || _listRef$current === void 0 ? void 0 : _listRef$current.scrollTo(scrollTop);
  };
  return /*#__PURE__*/_react.default.createElement(_reactVirtualized.WindowScroller, {
    onScroll: onScroll,
    scrollElement: props.scrollElement,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, ({
    registerChild
  }) => /*#__PURE__*/_react.default.createElement(_reactVirtualized.AutoSizer, {
    disableHeight: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, ({
    width
  }) => /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "waterfall",
    ref: registerChild,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_reactWindow.VariableSizeList, {
    ref: listRef,
    style: {
      height: '100%'
    },
    itemCount: visibleTraceList.length,
    itemSize: getRowSize,
    height: window.innerHeight,
    width: width,
    itemData: {
      ...props,
      traceList: visibleTraceList,
      onLoad: onRowLoad
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  }, VirtualRow))));
}
const VirtualRow = /*#__PURE__*/_react.default.memo(({
  index,
  style,
  data
}) => {
  const {
    onLoad,
    traceList,
    ...props
  } = data;
  const ref = _react.default.useRef(null);
  (0, _react.useEffect)(() => {
    var _ref$current$getBound, _ref$current;
    onLoad(index, (_ref$current$getBound = (_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : _ref$current.getBoundingClientRect().height) !== null && _ref$current$getBound !== void 0 ? _ref$current$getBound : ACCORDION_HEIGHT);
  }, [index, onLoad]);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: style,
    ref: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(WaterfallNode, (0, _extends2.default)({}, props, {
    node: traceList[index],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  })));
}, _reactWindow.areEqual);
const WaterfallNode = /*#__PURE__*/_react.default.memo(props => {
  var _criticalPathSegments, _node$item$doc$event;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    duration,
    waterfallItemId,
    onClickWaterfallItem,
    getRelatedErrorsHref,
    timelineMargins,
    node
  } = props;
  const {
    criticalPathSegmentsById,
    getErrorCount,
    updateTreeNode,
    showCriticalPath,
    isEmbeddable
  } = (0, _use_waterfall.useWaterfallContext)();
  const displayedColor = showCriticalPath ? (0, _polished.transparentize)(0.5, node.item.color) : node.item.color;
  const marginLeftLevel = 8 * node.level;
  const hasToggle = !!node.childrenToLoad;
  const errorCount = getErrorCount(node.item.id);
  const segments = (_criticalPathSegments = criticalPathSegmentsById[node.item.id]) === null || _criticalPathSegments === void 0 ? void 0 : _criticalPathSegments.filter(segment => segment.self).map(segment => ({
    id: segment.item.id,
    color: euiTheme.colors.accent,
    left: (segment.offset - node.item.offset - node.item.skew) / node.item.duration,
    width: segment.duration / node.item.duration
  }));
  const toggleAccordion = () => {
    updateTreeNode({
      ...node,
      expanded: !node.expanded
    });
  };
  const onWaterfallItemClick = onClickWaterfallItem ? flyoutDetailTab => {
    onClickWaterfallItem(node.item, flyoutDetailTab);
  } : undefined;
  const hasError = ((_node$item$doc$event = node.item.doc.event) === null || _node$item$doc$event === void 0 ? void 0 : _node$item$doc$event.outcome) === 'failure';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    "data-test-subj": "accordionWaterfall",
    style: {
      position: 'relative'
    },
    buttonClassName: `button_${node.item.id}`,
    id: node.item.id,
    buttonContentClassName: "accordion__buttonContent",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(ToggleAccordionButton, {
      show: hasToggle,
      isOpen: node.expanded,
      childrenCount: node.childrenToLoad,
      onClick: toggleAccordion,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_waterfall_item.WaterfallItem, {
      key: node.item.id,
      timelineMargins: timelineMargins,
      color: displayedColor,
      item: node.item,
      hasToggle: hasToggle,
      totalDuration: duration,
      isSelected: node.item.id === waterfallItemId,
      errorCount: errorCount,
      marginLeftLevel: marginLeftLevel,
      onClick: onWaterfallItemClick,
      segments: segments,
      isEmbeddable: isEmbeddable,
      getRelatedErrorsHref: getRelatedErrorsHref,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 13
      }
    }))),
    arrowDisplay: "none",
    initialIsOpen: true,
    forceState: node.expanded ? 'open' : 'closed',
    onToggle: toggleAccordion,
    css: (0, _react2.css)`
        border-top: ${euiTheme.border.thin};
        .button_${node.item.id} {
          width: 100%;
          height: ${ACCORDION_HEIGHT}px;
          margin-left: ${marginLeftLevel}px;
          border-left: ${hasError ? `${euiTheme.border.width.thick} solid ${euiTheme.colors.danger};` : `${euiTheme.border.thin};`};
          &:hover {
            background-color: ${euiTheme.colors.lightestShade};
          }
        }
        .accordion__buttonContent {
          width: 100%;
          height: 100%;
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 5
    }
  });
});
function ToggleAccordionButton({
  show,
  isOpen,
  childrenCount,
  onClick
}) {
  if (!show) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: ACCORDION_HEIGHT,
      display: 'flex'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "center",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    onClick: e => {
      e.stopPropagation();
      onClick();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: isOpen ? 'arrowDown' : 'arrowRight',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      position: 'relative'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'absolute',
      top: '50%',
      transform: 'translate(0, -50%)'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: childrenCount,
    delay: "long",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 15
    }
  }, (0, _formatters.asBigNumber)(childrenCount)))))));
}