"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallContainer = WaterfallContainer;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _url_helpers = require("../../../../shared/links/url_helpers");
var _waterfall = require("./waterfall");
var _orphan_trace_items_warning = require("./waterfall/orphan_trace_items_warning");
var _waterfall_flyout = require("./waterfall/waterfall_flyout");
var _waterfall_legends = require("../../../../shared/trace_waterfall/waterfall_legends");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/waterfall_container/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const toggleFlyout = ({
  history,
  item,
  flyoutDetailTab
}) => {
  history.replace({
    ...history.location,
    search: (0, _url_helpers.fromQuery)({
      ...(0, _url_helpers.toQuery)(location.search),
      flyoutDetailTab,
      waterfallItemId: item === null || item === void 0 ? void 0 : item.id
    })
  });
};
function WaterfallContainer({
  serviceName,
  waterfallItemId,
  waterfall,
  showCriticalPath,
  onShowCriticalPathChange
}) {
  const history = (0, _reactRouterDom.useHistory)();
  if (!waterfall) {
    return null;
  }
  const {
    legends,
    colorBy,
    orphanTraceItemsCount
  } = waterfall;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "showCriticalPath",
    label: _i18n.i18n.translate('xpack.apm.waterfall.showCriticalPath', {
      defaultMessage: 'Show critical path'
    }),
    checked: showCriticalPath,
    onChange: event => {
      onShowCriticalPathChange(event.target.checked);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_waterfall_legends.WaterfallLegends, {
    serviceName: serviceName,
    legends: legends,
    type: colorBy,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  })), orphanTraceItemsCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_orphan_trace_items_warning.OrphanTraceItemsWarning, {
    orphanTraceItemsCount: orphanTraceItemsCount,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 15
    }
  })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_waterfall.Waterfall, {
    showCriticalPath: showCriticalPath,
    waterfallItemId: waterfallItemId,
    waterfall: waterfall,
    onNodeClick: (item, flyoutDetailTab) => toggleFlyout({
      history,
      item,
      flyoutDetailTab
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_waterfall_flyout.WaterfallFlyout, {
    waterfallItemId: waterfallItemId,
    waterfall: waterfall,
    toggleFlyout: toggleFlyout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }));
}