"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionTypeSelect = TransactionTypeSelect;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/alerting/ui_components/alert_details_app_section/transaction_type_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TransactionTypeSelect({
  transactionType,
  transactionTypes,
  onChange
}) {
  const options = transactionTypes.map(t => ({
    text: t,
    value: t
  }));
  const transactionTypeLabel = _i18n.i18n.translate('xpack.apm.alertingVisualizations.transactionType.prepend', {
    defaultMessage: 'Transaction Type'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    style: {
      minWidth: 160
    },
    compressed: true,
    "data-test-subj": "alertingFilterTransactionType",
    prepend: transactionTypeLabel,
    onChange: event => onChange(event.target.value),
    options: options,
    value: transactionType,
    "aria-label": transactionTypeLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  });
}