"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findMaintenanceWindowsRoute = void 0;
var _lib = require("../../../../lib");
var _types = require("../../../../../types");
var _common = require("../../../../../../common");
var _find = require("../../../../../../common/routes/maintenance_window/external/apis/find");
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findMaintenanceWindowsRoute = (router, licenseState) => {
  router.get({
    path: _types.FIND_MAINTENANCE_WINDOWS_API_PATH,
    validate: {
      request: {
        query: _find.findMaintenanceWindowsQuerySchemaV1
      },
      response: {
        200: {
          body: () => _find.findMaintenanceWindowsResponseSchemaV1,
          description: 'Indicates a successful call.'
        },
        400: {
          description: 'Indicates an invalid schema or parameters.'
        },
        403: {
          description: 'Indicates that this call is forbidden.'
        }
      }
    },
    security: {
      authz: {
        requiredPrivileges: [`${_common.MAINTENANCE_WINDOW_API_PRIVILEGES.READ_MAINTENANCE_WINDOW}`]
      }
    },
    options: {
      access: 'public',
      summary: 'Search for a maintenance window.',
      tags: ['oas-tag:maintenance-window'],
      availability: {
        since: '9.2.0',
        stability: 'stable'
      }
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForMaintenanceWindow();
    const query = req.query || {};
    const maintenanceWindowClient = (await context.alerting).getMaintenanceWindowClient();
    const options = (0, _transforms.transformFindMaintenanceWindowParamsV1)(query);
    const findResult = await maintenanceWindowClient.find(options);
    const responseBody = (0, _transforms.transformFindMaintenanceWindowResponseV1)(findResult);
    return res.ok({
      body: responseBody
    });
  })));
};
exports.findMaintenanceWindowsRoute = findMaintenanceWindowsRoute;