"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertDeletePreviewRoute = void 0;
var _constants = require("@kbn/spaces-plugin/common/constants");
var _alert_delete = require("../../../../../common/routes/alert_delete");
var _types = require("../../../../types");
var _lib = require("../../../lib");
var _common = require("../../../../../common");
var _transforms = require("../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertDeletePreviewRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/settings/_alert_delete_preview`,
    validate: {
      query: _alert_delete.alertDeletePreviewQuerySchemaV1
    },
    security: {
      authz: {
        requiredPrivileges: [`${_common.API_PRIVILEGES.READ_ALERT_DELETE_SETTINGS}`]
      }
    },
    options: {
      access: 'internal'
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const alertDeletionClient = alertingContext.getAlertDeletionClient();
    const rulesClient = await alertingContext.getRulesClient();
    const spaceId = rulesClient.getSpaceId();
    const settings = (0, _transforms.transformRequestToAlertDeletePreviewV1)(req.query);
    if (!settings.isActiveAlertDeleteEnabled && !settings.isInactiveAlertDeleteEnabled) {
      return res.badRequest({
        body: {
          message: 'active_alert_delete_threshold or inactive_alert_delete_threshold must be set'
        }
      });
    }
    const affectedAlertCount = await alertDeletionClient.previewTask(settings, spaceId || _constants.DEFAULT_SPACE_ID);
    const response = (0, _transforms.transformAlertDeletePreviewToResponse)({
      affectedAlertCount
    });
    return res.ok({
      body: response
    });
  })));
};
exports.alertDeletePreviewRoute = alertDeletePreviewRoute;