"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisResultsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _state = require("@kbn/aiops-log-rate-analysis/state");
var _use_columns = require("./use_columns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_rate_analysis_results_table/log_rate_analysis_results_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PAGINATION_SIZE_OPTIONS = [5, 10, 20, 50];
const DEFAULT_SORT_FIELD = 'pValue';
const DEFAULT_SORT_FIELD_ZERO_DOCS_FALLBACK = 'doc_count';
const DEFAULT_SORT_DIRECTION = 'asc';
const DEFAULT_SORT_DIRECTION_ZERO_DOCS_FALLBACK = 'desc';
const LogRateAnalysisResultsTable = ({
  groupFilter,
  searchQuery,
  barColorOverride,
  barHighlightColorOverride,
  skippedColumns
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const primaryBackgroundColor = (0, _eui.useEuiBackgroundColor)('primary');
  const allItems = (0, _state.useAppSelector)(s => s.logRateAnalysisResults.significantItems);
  const allSignificantItems = (0, _react.useMemo)(() => {
    return allItems.map(item => ({
      ...item,
      logRateChangeSort: item.bg_count > 0 ? item.doc_count / item.bg_count : Number.POSITIVE_INFINITY
    }));
  }, [allItems]);
  const significantItems = (0, _react.useMemo)(() => {
    if (!groupFilter) {
      return allSignificantItems;
    }
    return groupFilter.reduce((p, groupItem) => {
      const st = allSignificantItems.find(d => d.fieldName === groupItem.fieldName && d.fieldValue === groupItem.fieldValue);
      if (st !== undefined) {
        var _groupItem$duplicate;
        p.push({
          ...st,
          unique: ((_groupItem$duplicate = groupItem.duplicate) !== null && _groupItem$duplicate !== void 0 ? _groupItem$duplicate : 0) <= 1
        });
      }
      return p;
    }, []);
  }, [allSignificantItems, groupFilter]);
  const zeroDocsFallback = (0, _state.useAppSelector)(s => s.logRateAnalysisResults.zeroDocsFallback);
  const pinnedGroup = (0, _state.useAppSelector)(s => s.logRateAnalysisTable.pinnedGroup);
  const selectedGroup = (0, _state.useAppSelector)(s => s.logRateAnalysisTable.selectedGroup);
  const pinnedSignificantItem = (0, _state.useAppSelector)(s => s.logRateAnalysisTable.pinnedSignificantItem);
  const selectedSignificantItem = (0, _state.useAppSelector)(s => s.logRateAnalysisTable.selectedSignificantItem);
  const dispatch = (0, _state.useAppDispatch)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sortField, setSortField] = (0, _react.useState)(zeroDocsFallback ? DEFAULT_SORT_FIELD_ZERO_DOCS_FALLBACK : DEFAULT_SORT_FIELD);
  const [sortDirection, setSortDirection] = (0, _react.useState)(zeroDocsFallback ? DEFAULT_SORT_DIRECTION_ZERO_DOCS_FALLBACK : DEFAULT_SORT_DIRECTION);
  const columns = (0, _use_columns.useColumns)(_use_columns.LOG_RATE_ANALYSIS_RESULTS_TABLE_TYPE.SIGNIFICANT_ITEMS, skippedColumns, searchQuery, barColorOverride, barHighlightColorOverride, groupFilter !== undefined);
  const onChange = (0, _react.useCallback)(tableSettings => {
    if (tableSettings.page) {
      const {
        index,
        size
      } = tableSettings.page;
      setPageIndex(index);
      setPageSize(size);
    }
    if (tableSettings.sort) {
      const {
        field,
        direction
      } = tableSettings.sort;
      setSortField(field);
      setSortDirection(direction);
    }
  }, []);
  const {
    pagination,
    pageOfItems,
    sorting
  } = (0, _react.useMemo)(() => {
    var _significantItems$len;
    const pageStart = pageIndex * pageSize;
    const itemCount = (_significantItems$len = significantItems === null || significantItems === void 0 ? void 0 : significantItems.length) !== null && _significantItems$len !== void 0 ? _significantItems$len : 0;
    let items = significantItems !== null && significantItems !== void 0 ? significantItems : [];
    const sortIteratees = [item => {
      if (item && typeof item[sortField] === 'string') {
        // @ts-ignore Object is possibly null or undefined
        return item[sortField].toLowerCase();
      }
      return item[sortField];
    }];
    const sortDirections = [sortDirection];

    // If the table is sorted by p-value or log rate change, add a secondary sort by doc count.
    if (sortField === 'pValue' || sortField === 'logRateChangeSort') {
      sortIteratees.push(item => item.doc_count);
      sortDirections.push(sortDirection);
    }
    items = (0, _lodash.orderBy)(significantItems, sortIteratees, sortDirections);
    return {
      pageOfItems: items.slice(pageStart, pageStart + pageSize),
      pagination: {
        pageIndex,
        pageSize,
        totalItemCount: itemCount,
        pageSizeOptions: PAGINATION_SIZE_OPTIONS
      },
      sorting: {
        sort: {
          field: sortField,
          direction: sortDirection
        }
      }
    };
  }, [pageIndex, pageSize, sortField, sortDirection, significantItems]);
  (0, _react.useEffect)(() => {
    // If no row is hovered or pinned or the user switched to a new page,
    // fall back to set the first row into a hovered state to make the
    // main document count chart show a comparison view by default.
    if ((selectedSignificantItem === null || !pageOfItems.some(item => (0, _lodash.isEqual)(item, selectedSignificantItem))) && pinnedSignificantItem === null && pageOfItems.length > 0 && selectedGroup === null && pinnedGroup === null) {
      dispatch((0, _state.setSelectedSignificantItem)(pageOfItems[0]));
    }

    // If a user switched pages and a pinned row is no longer visible
    // on the current page, set the status of pinned rows back to `null`.
    if (pinnedSignificantItem !== null && !pageOfItems.some(item => (0, _lodash.isEqual)(item, pinnedSignificantItem)) && selectedGroup === null && pinnedGroup === null) {
      dispatch((0, _state.setPinnedSignificantItem)(null));
    }
  }, [dispatch, selectedGroup, selectedSignificantItem, pageOfItems, pinnedGroup, pinnedSignificantItem]);

  // When the analysis results table unmounts,
  // make sure to reset any hovered or pinned rows.
  (0, _react.useEffect)(() => () => {
    dispatch((0, _state.setSelectedSignificantItem)(null));
    dispatch((0, _state.setPinnedSignificantItem)(null));
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const getRowStyle = significantItem => {
    if (pinnedSignificantItem && pinnedSignificantItem.fieldName === significantItem.fieldName && pinnedSignificantItem.fieldValue === significantItem.fieldValue) {
      return {
        backgroundColor: primaryBackgroundColor
      };
    }
    if (selectedSignificantItem && selectedSignificantItem.fieldName === significantItem.fieldName && selectedSignificantItem.fieldValue === significantItem.fieldValue) {
      return {
        backgroundColor: euiTheme.colors.lightestShade
      };
    }
    return {
      backgroundColor: euiTheme.colors.emptyShade
    };
  };

  // Don't pass on the `loading` state to the table itself because
  // it disables hovering events. Because the mini histograms take a while
  // to load, hovering would not update the main chart. Instead,
  // the loading state is shown by the progress bar on the outer component level.
  // The outer component also will display a prompt when no data was returned
  // running the analysis and will hide this table.

  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "aiopsLogRateAnalysisResultsTable",
    compressed: true,
    items: pageOfItems,
    columns: columns,
    pagination: pagination.totalItemCount > pagination.pageSize ? pagination : undefined,
    sorting: sorting,
    loading: false,
    onChange: onChange,
    rowProps: significantItem => {
      return {
        'data-test-subj': `aiopsLogRateAnalysisResultsTableRow row-${significantItem.fieldName}-${significantItem.fieldValue}`,
        onClick: () => {
          if (significantItem.fieldName === (pinnedSignificantItem === null || pinnedSignificantItem === void 0 ? void 0 : pinnedSignificantItem.fieldName) && significantItem.fieldValue === (pinnedSignificantItem === null || pinnedSignificantItem === void 0 ? void 0 : pinnedSignificantItem.fieldValue)) {
            dispatch((0, _state.setPinnedSignificantItem)(null));
          } else {
            dispatch((0, _state.setPinnedSignificantItem)(significantItem));
          }
        },
        onMouseEnter: () => {
          if (pinnedSignificantItem === null) {
            dispatch((0, _state.setSelectedSignificantItem)(significantItem));
          }
        },
        onMouseLeave: () => {
          dispatch((0, _state.setSelectedSignificantItem)(null));
        },
        style: getRowStyle(significantItem)
      };
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 5
    }
  });
};
exports.LogRateAnalysisResultsTable = LogRateAnalysisResultsTable;