"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisForEmbeddable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _esQuery = require("@kbn/es-query");
var _dataService = require("@kbn/data-service");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_filters_query = require("../../hooks/use_filters_query");
var _use_search = require("../../hooks/use_search");
var _use_data_source = require("../../hooks/use_data_source");
var _log_rate_analysis = require("../../application/url_state/log_rate_analysis");
var _log_rate_analysis_document_count_chart_data = require("./log_rate_analysis_content/log_rate_analysis_document_count_chart_data");
var _log_rate_analysis_content = require("./log_rate_analysis_content/log_rate_analysis_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_rate_analysis/log_rate_analysis_for_embeddable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogRateAnalysisForEmbeddable = ({
  timeRange
}) => {
  const {
    uiSettings
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const {
    filters,
    query
  } = (0, _use_filters_query.useFilterQueryUpdates)();
  const appState = (0, _log_rate_analysis.getDefaultLogRateAnalysisAppState)({
    searchQuery: (0, _esQuery.buildEsQuery)(dataView, query !== null && query !== void 0 ? query : [], filters !== null && filters !== void 0 ? filters : [], uiSettings ? (0, _dataService.getEsQueryConfig)(uiSettings) : undefined),
    filters
  });
  const {
    searchQuery
  } = (0, _use_search.useSearch)({
    dataView,
    savedSearch: null
  }, appState, true);
  const timeRangeParsed = (0, _react.useMemo)(() => {
    if (timeRange) {
      const min = _datemath.default.parse(timeRange.from);
      const max = _datemath.default.parse(timeRange.to);
      if (min && max) {
        return {
          min,
          max
        };
      }
    }
  }, [timeRange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_log_rate_analysis_document_count_chart_data.LogRateAnalysisDocumentCountChartData, {
    timeRange: timeRangeParsed,
    esSearchQuery: searchQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_log_rate_analysis_content.LogRateAnalysisContent, {
    esSearchQuery: searchQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }));
};
exports.LogRateAnalysisForEmbeddable = LogRateAnalysisForEmbeddable;