"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCategorizationJobButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _mlUiActions = require("@kbn/ml-ui-actions");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_categorization/create_categorization_job.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CreateCategorizationJobButton = ({
  dataView,
  field,
  query,
  earliest,
  latest,
  iconOnly = false
}) => {
  const {
    uiActions,
    application: {
      capabilities
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const createADJob = () => {
    if (uiActions === undefined) {
      return;
    }
    const triggerOptions = {
      dataView,
      field,
      query,
      timeRange: {
        from: (0, _moment.default)(earliest).toISOString(),
        to: (0, _moment.default)(latest).toISOString()
      }
    };
    uiActions.getTrigger(_mlUiActions.CREATE_PATTERN_ANALYSIS_TO_ML_AD_JOB_TRIGGER).exec(triggerOptions);
  };
  if (uiActions === undefined || capabilities.ml.canCreateJob === false) {
    return null;
  }
  if (iconOnly) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.aiops.categorizeFlyout.findAnomalies.tooltip', {
        defaultMessage: 'Create anomaly detection job to find anomalies in patterns'
      }),
      disableScreenReaderOutput: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "aiopsEmbeddableMenuOptionsButton",
      size: "s",
      iconType: "machineLearningApp",
      onClick: createADJob
      // @ts-ignore - subdued does work
      ,
      color: "subdued",
      "aria-label": _i18n.i18n.translate('xpack.aiops.categorizeFlyout.findAnomalies.tooltip', {
        defaultMessage: 'Create anomaly detection job to find anomalies in patterns'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "aiopsLogCategorizationFlyoutAdJobButton",
    onClick: createADJob,
    flush: "left",
    iconSide: "left",
    iconType: 'machineLearningApp',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.categorizeFlyout.findAnomalies",
    defaultMessage: "Find anomalies in patterns",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }));
};
exports.CreateCategorizationJobButton = CreateCategorizationJobButton;