"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeAsEsqlAgent = executeAsEsqlAgent;
var _elasticsearch = require("@elastic/elasticsearch");
var _inferenceCommon = require("@kbn/inference-common");
var _server = require("@kbn/inference-plugin/server");
var _inferencePromptUtils = require("@kbn/inference-prompt-utils");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _esQuery = require("@kbn/es-query");
var _ = require("../../..");
var _prompt = require("./prompt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadEsqlDocBase = (0, _lodash.once)(() => _server.EsqlDocumentBase.load());
async function executeAsEsqlAgent({
  inferenceClient,
  esClient,
  start,
  end,
  signal,
  prompt,
  toolCallbacks
}) {
  const docBase = await loadEsqlDocBase();
  async function runEsqlQuery(query) {
    return await (0, _server.runAndValidateEsqlQuery)({
      query,
      client: esClient
    }).then(response => {
      var _response$errorMessag;
      if (response.error || (_response$errorMessag = response.errorMessages) !== null && _response$errorMessag !== void 0 && _response$errorMessag.length) {
        return {
          error: response.error && response.error instanceof _elasticsearch.errors.ResponseError ? (0, _lodash.omit)(response.error, 'meta') : response.error,
          errorMessages: response.errorMessages
        };
      }
      return {
        columns: response.columns,
        rows: response.rows
      };
    });
  }
  const assistantReply = await (0, _inferencePromptUtils.executeAsReasoningAgent)({
    inferenceClient,
    prompt: _prompt.EsqlPrompt,
    abortSignal: signal,
    toolCallbacks: {
      ...toolCallbacks,
      list_datasets: async toolCall => {
        return {
          response: await esClient.indices.resolveIndex({
            name: (0, _esQuery.indexPatternToCcs)(toolCall.function.arguments.name.length ? toolCall.function.arguments.name.flatMap(index => index.split(',')) : '*'),
            allow_no_indices: true
          }).then(response => {
            return {
              ...response,
              data_streams: response.data_streams.map(dataStream => {
                return {
                  name: dataStream.name,
                  timestamp_field: dataStream.timestamp_field
                };
              })
            };
          })
        };
      },
      describe_dataset: async toolCall => {
        const analysis = await (0, _.describeDataset)({
          esClient,
          index: toolCall.function.arguments.index,
          kql: toolCall.function.arguments.kql,
          start: start !== null && start !== void 0 ? start : (0, _moment.default)().subtract(24, 'hours').valueOf(),
          end: end !== null && end !== void 0 ? end : (0, _moment.default)().valueOf()
        });
        return {
          response: {
            analysis: (0, _.sortAndTruncateAnalyzedFields)(analysis)
          }
        };
      },
      get_documentation: async toolCall => {
        return {
          response: docBase.getDocumentation(toolCall.function.arguments.commands.concat(toolCall.function.arguments.functions), {
            generateMissingKeywordDoc: true
          })
        };
      },
      run_queries: async toolCall => {
        const results = await Promise.all(toolCall.function.arguments.queries.map(async query => {
          var _response$columns, _response$rows$map, _response$rows;
          const response = await runEsqlQuery(query);
          const cols = (_response$columns = response.columns) !== null && _response$columns !== void 0 ? _response$columns : [];
          const docs = (_response$rows$map = (_response$rows = response.rows) === null || _response$rows === void 0 ? void 0 : _response$rows.map(row => {
            const doc = {};
            row.forEach((value, idx) => {
              const col = cols[idx];
              if (value !== null) {
                doc[col.name] = value;
              }
            });
          })) !== null && _response$rows$map !== void 0 ? _response$rows$map : [];
          return {
            query,
            response: {
              docs: (0, _inferenceCommon.truncateList)(docs, 50)
            }
          };
        }));
        return {
          response: {
            results
          }
        };
      },
      validate_queries: async toolCall => {
        const results = await Promise.all(toolCall.function.arguments.queries.map(async query => {
          return {
            query,
            validation: await runEsqlQuery(query + ' | LIMIT 0').then(response => {
              var _response$columns$map, _response$columns2;
              if ('error' in response) {
                return {
                  valid: false,
                  ...response
                };
              }
              const cols = (0, _inferenceCommon.truncateList)((_response$columns$map = (_response$columns2 = response.columns) === null || _response$columns2 === void 0 ? void 0 : _response$columns2.map(col => col.name)) !== null && _response$columns$map !== void 0 ? _response$columns$map : [], 10);
              return {
                valid: true,
                ...(cols.length ? {
                  columns: cols
                } : {})
              };
            })
          };
        }));
        return {
          response: {
            results
          }
        };
      }
    },
    input: {
      prompt,
      esql_system_prompt: docBase.getSystemMessage()
    }
  });
  return assistantReply;
}