"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveServiceRedirectionBindingNode = resolveServiceRedirectionBindingNode;
const isPlanServiceRedirectionBindingNode_1 = require("../../planning/calculations/isPlanServiceRedirectionBindingNode");
function resolveServiceRedirectionBindingNode(resolveBindingNode) {
    function innerResolveServiceRedirectionBindingNode(params, node) {
        const resolvedValues = [];
        for (const redirection of node.redirections) {
            if ((0, isPlanServiceRedirectionBindingNode_1.isPlanServiceRedirectionBindingNode)(redirection)) {
                resolvedValues.push(...innerResolveServiceRedirectionBindingNode(params, redirection));
            }
            else {
                resolvedValues.push(resolveBindingNode(params, redirection));
            }
        }
        return resolvedValues;
    }
    return innerResolveServiceRedirectionBindingNode;
}
//# sourceMappingURL=resolveServiceRedirectionBindingNode.js.map