"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.curryLazyBuildPlanServiceNodeFromResolvedValueElementMetadata = curryLazyBuildPlanServiceNodeFromResolvedValueElementMetadata;
const InversifyCoreError_1 = require("../../error/models/InversifyCoreError");
const InversifyCoreErrorKind_1 = require("../../error/models/InversifyCoreErrorKind");
const curryBuildPlanServiceNodeFromResolvedValueElementMetadata_1 = require("./curryBuildPlanServiceNodeFromResolvedValueElementMetadata");
function curryLazyBuildPlanServiceNodeFromResolvedValueElementMetadata(buildServiceNodeBindings) {
    const buildPlanServiceNodeFromResolvedValueElementMetadata = (0, curryBuildPlanServiceNodeFromResolvedValueElementMetadata_1.curryBuildPlanServiceNodeFromResolvedValueElementMetadata)(buildServiceNodeBindings);
    return (params, bindingConstraintsList, elementMetadata) => {
        try {
            return buildPlanServiceNodeFromResolvedValueElementMetadata(params, bindingConstraintsList, elementMetadata);
        }
        catch (error) {
            if (InversifyCoreError_1.InversifyCoreError.isErrorOfKind(error, InversifyCoreErrorKind_1.InversifyCoreErrorKind.planning)) {
                return undefined;
            }
            throw error;
        }
    };
}
//# sourceMappingURL=curryLazyBuildPlanServiceNodeFromResolvedValueElementMetadata.js.map