"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.injectFromHierarchy = injectFromHierarchy;
const prototype_utils_1 = require("@inversifyjs/prototype-utils");
const injectFrom_1 = require("./injectFrom");
function injectFromHierarchy(options) {
    // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
    return (target) => {
        const chain = [];
        let current = (0, prototype_utils_1.getBaseType)(target);
        while (current !== undefined && current !== Object) {
            const ancestor = current;
            chain.push(ancestor);
            current = (0, prototype_utils_1.getBaseType)(ancestor);
        }
        chain.reverse();
        for (const type of chain) {
            (0, injectFrom_1.injectFrom)({ ...options, type })(target);
        }
    };
}
//# sourceMappingURL=injectFromHierarchy.js.map