"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeactivationsService = void 0;
const chain_1 = require("../../common/calculations/chain");
const OneToManyMapStar_1 = require("../../common/models/OneToManyMapStar");
var DeactivationRelationKind;
(function (DeactivationRelationKind) {
    DeactivationRelationKind["moduleId"] = "moduleId";
    DeactivationRelationKind["serviceId"] = "serviceId";
})(DeactivationRelationKind || (DeactivationRelationKind = {}));
class DeactivationsService {
    #deactivationMaps;
    #getParent;
    constructor(getParent, deactivationMaps) {
        this.#deactivationMaps =
            deactivationMaps ??
                new OneToManyMapStar_1.OneToManyMapStar({
                    moduleId: {
                        isOptional: true,
                    },
                    serviceId: {
                        isOptional: false,
                    },
                });
        this.#getParent = getParent;
    }
    static build(getParent) {
        return new DeactivationsService(getParent);
    }
    add(deactivation, relation) {
        this.#deactivationMaps.add(deactivation, relation);
    }
    clone() {
        const clone = new DeactivationsService(this.#getParent, this.#deactivationMaps.clone());
        return clone;
    }
    get(serviceIdentifier) {
        const deactivationIterables = [];
        const deactivations = this.#deactivationMaps.get(DeactivationRelationKind.serviceId, serviceIdentifier);
        if (deactivations !== undefined) {
            deactivationIterables.push(deactivations);
        }
        const parentDeactivations = this.#getParent()?.get(serviceIdentifier);
        if (parentDeactivations !== undefined) {
            deactivationIterables.push(parentDeactivations);
        }
        if (deactivationIterables.length === 0) {
            return undefined;
        }
        return (0, chain_1.chain)(...deactivationIterables);
    }
    removeAllByModuleId(moduleId) {
        this.#deactivationMaps.removeByRelation(DeactivationRelationKind.moduleId, moduleId);
    }
    removeAllByServiceId(serviceId) {
        this.#deactivationMaps.removeByRelation(DeactivationRelationKind.serviceId, serviceId);
    }
}
exports.DeactivationsService = DeactivationsService;
//# sourceMappingURL=DeactivationsService.js.map