"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiRangeInputStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiRangeInputStyles = exports.euiRangeInputStyles = function euiRangeInputStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  return {
    euiRangeInput: /*#__PURE__*/(0, _react.css)("inline-size:auto;min-inline-size:", euiTheme.base * (isRefreshVariant ? 3.5 : 4), "px;.euiRange__popover &,.euiDualRange__popover &{inline-size:100%;};label:euiRangeInput;")
  };
};