"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BrushTool = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const common_1 = require("../../chart_types/xy_chart/state/utils/common");
const color_library_wrappers_1 = require("../../common/color_library_wrappers");
const colors_1 = require("../../common/colors");
const canvas_1 = require("../../renderers/canvas");
const rect_1 = require("../../renderers/canvas/primitives/rect");
const brush_axis_1 = require("../../specs/brush_axis");
const default_settings_spec_1 = require("../../specs/default_settings_spec");
const get_chart_rotation_1 = require("../../state/selectors/get_chart_rotation");
const get_chart_theme_1 = require("../../state/selectors/get_chart_theme");
const get_internal_chart_state_1 = require("../../state/selectors/get_internal_chart_state");
const get_internal_is_intialized_1 = require("../../state/selectors/get_internal_is_intialized");
const get_settings_spec_1 = require("../../state/selectors/get_settings_spec");
const light_theme_1 = require("../../utils/themes/light_theme");
const BRUSH_STROKED_SIDES = Object.freeze({
    TOP_BOTTOM: { top: true, bottom: true, left: false, right: false },
    LEFT_RIGHT: { left: true, right: true, top: false, bottom: false },
    ALL: { top: true, right: true, bottom: true, left: true },
});
class BrushToolComponent extends react_1.default.Component {
    static displayName = 'BrushTool';
    devicePixelRatio;
    ctx;
    canvasRef;
    constructor(props) {
        super(props);
        this.ctx = null;
        this.devicePixelRatio = window.devicePixelRatio;
        this.canvasRef = react_1.default.createRef();
    }
    componentDidMount() {
        this.tryCanvasContext();
        this.drawCanvas();
    }
    componentDidUpdate() {
        if (!this.ctx) {
            this.tryCanvasContext();
        }
        if (this.props.initialized) {
            this.drawCanvas();
        }
    }
    render() {
        const { initialized, isBrushAvailable, isBrushing, projectionContainer, zIndex } = this.props;
        if (!initialized || !isBrushAvailable || !isBrushing) {
            this.ctx = null;
            return null;
        }
        const { width, height } = projectionContainer;
        return (react_1.default.createElement("canvas", { ref: this.canvasRef, className: "echBrushTool", width: width * this.devicePixelRatio, height: height * this.devicePixelRatio, style: {
                width,
                height,
                zIndex,
            } }));
    }
    drawCanvas = () => {
        const { brushEvent, mainProjectionArea, style, brushAxis, chartRotation } = this.props;
        const { ctx } = this;
        if (!ctx || !brushEvent) {
            return;
        }
        const strokedSides = getBrushStrokedSides(chartRotation, brushAxis);
        const { top, left, width, height } = brushEvent;
        (0, canvas_1.withContext)(ctx, () => {
            ctx.scale(this.devicePixelRatio, this.devicePixelRatio);
            (0, canvas_1.withClip)(ctx, {
                x: mainProjectionArea.left,
                y: mainProjectionArea.top,
                width: mainProjectionArea.width,
                height: mainProjectionArea.height,
            }, () => {
                (0, canvas_1.clearCanvas)(ctx, colors_1.Colors.Transparent.keyword);
                ctx.translate(mainProjectionArea.left, mainProjectionArea.top);
                (0, rect_1.renderRect)(ctx, { x: left, y: top, width, height }, { color: (0, color_library_wrappers_1.overrideOpacity)((0, color_library_wrappers_1.colorToRgba)(style.fill), style.opacity) }, { width: 0, color: colors_1.Colors.Transparent.rgba });
                (0, rect_1.renderRectStroke)(ctx, { x: left, y: top, width, height }, {
                    width: style.strokeWidth,
                    color: (0, color_library_wrappers_1.colorToRgba)(style.stroke),
                }, strokedSides);
            });
        });
    };
    tryCanvasContext() {
        const canvas = this.canvasRef.current;
        this.ctx = canvas && canvas.getContext('2d');
    }
}
const mapStateToProps = (state) => {
    const internalChartState = (0, get_internal_chart_state_1.getInternalChartStateSelector)(state);
    if (internalChartState === null || (0, get_internal_is_intialized_1.getInternalIsInitializedSelector)(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return {
            initialized: false,
            projectionContainer: {
                width: 0,
                height: 0,
                left: 0,
                top: 0,
            },
            mainProjectionArea: {
                top: 0,
                left: 0,
                width: 0,
                height: 0,
            },
            isBrushing: false,
            isBrushAvailable: false,
            brushEvent: null,
            zIndex: 0,
            style: light_theme_1.LIGHT_THEME.brush,
            brushAxis: default_settings_spec_1.DEFAULT_SETTINGS_SPEC.brushAxis,
            chartRotation: default_settings_spec_1.DEFAULT_SETTINGS_SPEC.rotation,
        };
    }
    return {
        initialized: state.specsInitialized,
        projectionContainer: internalChartState.getProjectionContainerArea(state),
        mainProjectionArea: internalChartState.getMainProjectionArea(state),
        isBrushAvailable: internalChartState.isBrushAvailable(state),
        isBrushing: internalChartState.isBrushing(state),
        brushEvent: internalChartState.getBrushArea(state),
        zIndex: state.zIndex,
        style: (0, get_chart_theme_1.getChartThemeSelector)(state).brush,
        brushAxis: (0, get_settings_spec_1.getSettingsSpecSelector)(state).brushAxis,
        chartRotation: (0, get_chart_rotation_1.getChartRotationSelector)(state),
    };
};
function getBrushStrokedSides(rotation, brushAxis) {
    const vertical = (0, common_1.isVerticalRotation)(rotation);
    switch (brushAxis) {
        case brush_axis_1.BrushAxis.X:
            return vertical ? BRUSH_STROKED_SIDES.TOP_BOTTOM : BRUSH_STROKED_SIDES.LEFT_RIGHT;
        case brush_axis_1.BrushAxis.Y:
            return vertical ? BRUSH_STROKED_SIDES.LEFT_RIGHT : BRUSH_STROKED_SIDES.TOP_BOTTOM;
        default:
            return BRUSH_STROKED_SIDES.ALL;
    }
}
exports.BrushTool = (0, react_redux_1.connect)(mapStateToProps)(BrushToolComponent);
//# sourceMappingURL=brush.js.map