"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteFieldModal = DeleteFieldModal;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/confirm_modals/delete_field_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const geti18nTexts = fieldsToDelete => {
  let modalTitle = '';
  let confirmButtonText = '';
  if (fieldsToDelete) {
    const isSingle = fieldsToDelete.length === 1;
    modalTitle = isSingle ? _i18n.i18n.translate('indexPatternFieldEditor.deleteRuntimeField.confirmModal.deleteSingleTitle', {
      defaultMessage: `Remove field ''{name}''`,
      values: {
        name: fieldsToDelete[0]
      }
    }) : _i18n.i18n.translate('indexPatternFieldEditor.deleteRuntimeField.confirmModal.deleteMultipleTitle', {
      defaultMessage: `Remove {count} fields`,
      values: {
        count: fieldsToDelete.length
      }
    });
    confirmButtonText = isSingle ? _i18n.i18n.translate('indexPatternFieldEditor.deleteRuntimeField.confirmationModal.removeButtonLabel', {
      defaultMessage: `Remove field`
    }) : _i18n.i18n.translate('indexPatternFieldEditor.deleteRuntimeField.confirmationModal.removeMultipleButtonLabel', {
      defaultMessage: `Remove fields`
    });
  }
  return {
    modalTitle,
    confirmButtonText,
    cancelButtonText: _i18n.i18n.translate('indexPatternFieldEditor.deleteRuntimeField.confirmationModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    warningMultipleFields: _i18n.i18n.translate('indexPatternFieldEditor.deleteRuntimeField.confirmModal.multipleDeletionDescription', {
      defaultMessage: 'You are about to remove these runtime fields:'
    }),
    typeConfirm: _i18n.i18n.translate('indexPatternFieldEditor.deleteRuntimeField.confirmModal.typeConfirm', {
      defaultMessage: 'Enter REMOVE to confirm'
    }),
    warningRemovingFields: _i18n.i18n.translate('indexPatternFieldEditor.deleteRuntimeField.confirmModal.warningRemovingFields', {
      defaultMessage: 'Removing fields can break searches and visualizations that rely on this field.'
    })
  };
};
function DeleteFieldModal({
  fieldsToDelete,
  closeModal,
  confirmDelete
}) {
  const i18nTexts = geti18nTexts(fieldsToDelete);
  const {
    modalTitle,
    confirmButtonText,
    cancelButtonText,
    warningMultipleFields
  } = i18nTexts;
  const isMultiple = Boolean(fieldsToDelete.length > 1);
  const [confirmContent, setConfirmContent] = (0, _react.useState)('');
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: modalTitle,
    titleProps: {
      id: modalTitleId
    },
    "data-test-subj": "runtimeFieldDeleteConfirmModal",
    onCancel: closeModal,
    onConfirm: confirmDelete,
    cancelButtonText: cancelButtonText,
    buttonColor: "danger",
    confirmButtonText: confirmButtonText,
    confirmButtonDisabled: (confirmContent === null || confirmContent === void 0 ? void 0 : confirmContent.toUpperCase()) !== 'REMOVE',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: i18nTexts.warningRemovingFields,
    iconType: "warning",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, isMultiple && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }, warningMultipleFields), /*#__PURE__*/_react.default.createElement("ul", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }, fieldsToDelete.map(fieldName => /*#__PURE__*/_react.default.createElement("li", {
    key: fieldName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 17
    }
  }, fieldName))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18nTexts.typeConfirm,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: confirmContent,
    onChange: e => setConfirmContent(e.target.value),
    "data-test-subj": "deleteModalConfirmText",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  })));
}