"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RollupDeprecatedWarning = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_editor/public/components/rollup_deprecated_warning/rollup_deprecated_warning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const rollupBetaWarningTitle = _i18n.i18n.translate('indexPatternEditor.rollupIndexPattern.deprecationWarning.title', {
  defaultMessage: 'Deprecated in 8.11.0'
});
const RollupDeprecatedWarning = ({
  docLinksService
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: rollupBetaWarningTitle,
  color: "warning",
  iconType: "question",
  "data-test-subj": "rollupDeprecationCallout",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.rollupDataView.deprecationWarning.textParagraphOne",
  defaultMessage: "Rollups are deprecated and will be removed in a future version. {downsamplingLink} can be used as an alternative.",
  values: {
    downsamplingLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinksService.links.elasticsearch.rollupMigratingToDownsampling,
      target: "_blank",
      "data-test-subj": "downsamplingLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('indexPatternEditor.rollupDataView.deprecationWarning.downsamplingLink', {
      defaultMessage: 'Downsampling'
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 35,
    columnNumber: 5
  }
}));
exports.RollupDeprecatedWarning = RollupDeprecatedWarning;