"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataUsageMetricsUrlParams = exports.getDataUsageMetricsFiltersFromUrlParams = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _rest_types = require("../../../common/rest_types");
var _use_url_params = require("../../hooks/use_url_params");
var _utils = require("../../../common/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDataUsageMetricsFiltersFromUrlParams = urlParams => {
  const dataUsageMetricsFilters = {
    metricTypes: [],
    dataStreams: [],
    startDate: _utils.DEFAULT_DATE_RANGE_OPTIONS.startDate,
    endDate: _utils.DEFAULT_DATE_RANGE_OPTIONS.endDate
  };
  const urlMetricTypes = urlParams.metricTypes ? String(urlParams.metricTypes).split(',').reduce((acc, curr) => {
    if ((0, _rest_types.isMetricType)(curr)) {
      acc.push(curr);
    }
    return acc.sort();
  }, []) : [];
  const urlDataStreams = urlParams.dataStreams ? String(urlParams.dataStreams).split(',') : [];
  dataUsageMetricsFilters.metricTypes = urlMetricTypes.length ? urlMetricTypes : undefined;
  dataUsageMetricsFilters.dataStreams = urlDataStreams.length ? urlDataStreams : undefined;
  dataUsageMetricsFilters.startDate = urlParams.startDate ? String(urlParams.startDate) : undefined;
  dataUsageMetricsFilters.endDate = urlParams.endDate ? String(urlParams.endDate) : undefined;
  return dataUsageMetricsFilters;
};
exports.getDataUsageMetricsFiltersFromUrlParams = getDataUsageMetricsFiltersFromUrlParams;
const useDataUsageMetricsUrlParams = () => {
  const location = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    urlParams,
    toUrlParams
  } = (0, _use_url_params.useUrlParams)();
  const getUrlDataUsageMetricsFilters = (0, _react.useMemo)(() => getDataUsageMetricsFiltersFromUrlParams(urlParams), [urlParams]);
  const [dataUsageMetricsFilters, setDataUsageMetricsFilters] = (0, _react.useState)(getUrlDataUsageMetricsFilters);
  const setUrlMetricTypesFilter = (0, _react.useCallback)(metricTypes => {
    history.push({
      ...location,
      search: toUrlParams({
        ...urlParams,
        metricTypes: metricTypes.length ? metricTypes : undefined
      })
    });
  }, [history, location, toUrlParams, urlParams]);
  const setUrlDataStreamsFilter = (0, _react.useCallback)(dataStreams => {
    history.push({
      ...location,
      search: toUrlParams({
        ...urlParams,
        dataStreams: dataStreams.length ? dataStreams : undefined
      })
    });
  }, [history, location, toUrlParams, urlParams]);
  const setUrlDateRangeFilter = (0, _react.useCallback)(({
    startDate,
    endDate
  }) => {
    history.push({
      ...location,
      search: toUrlParams({
        ...urlParams,
        startDate: startDate.length ? startDate : undefined,
        endDate: endDate.length ? endDate : undefined
      })
    });
  }, [history, location, toUrlParams, urlParams]);
  (0, _react.useEffect)(() => {
    setDataUsageMetricsFilters(prevState => {
      return {
        ...prevState,
        ...getDataUsageMetricsFiltersFromUrlParams(urlParams)
      };
    });
  }, [setDataUsageMetricsFilters, urlParams]);
  return {
    ...dataUsageMetricsFilters,
    setUrlDataStreamsFilter,
    setUrlDateRangeFilter,
    setUrlMetricTypesFilter
  };
};
exports.useDataUsageMetricsUrlParams = useDataUsageMetricsUrlParams;