"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retryEs = retryEs;
var _pRetry = _interopRequireDefault(require("p-retry"));
var _elasticsearch = require("@elastic/elasticsearch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const retryResponseStatuses = [401,
// AuthorizationException
403,
// AuthenticationException
408,
// RequestTimeout
410,
// Gone
429,
// TooManyRequests -> ES circuit breaker
503,
// ServiceUnavailable
504 // GatewayTimeout
];
function isRetryableEsClientError(e) {
  if (e instanceof _elasticsearch.errors.NoLivingConnectionsError || e instanceof _elasticsearch.errors.ConnectionError || e instanceof _elasticsearch.errors.TimeoutError || e instanceof _elasticsearch.errors.ResponseError && retryResponseStatuses.includes(e === null || e === void 0 ? void 0 : e.statusCode)) {
    return true;
  }
  return false;
}
function retryEs(fn) {
  return (0, _pRetry.default)(fn, {
    retries: 3,
    onFailedAttempt: error => {
      if (!isRetryableEsClientError(error)) {
        throw error;
      }
    }
  });
}