"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformSearchSourceIn = transformSearchSourceIn;
var _common = require("@kbn/data-plugin/common");
var _kibana_services = require("../../../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function transformSearchSourceIn(kibanaSavedObjectMeta) {
  if (!kibanaSavedObjectMeta || !kibanaSavedObjectMeta.searchSource) {
    return {
      searchSourceJSON: '{}',
      references: []
    };
  }
  const {
    searchSource
  } = kibanaSavedObjectMeta;
  try {
    // Extract references expects an object with singular `filter` and `query`.
    // But `DashboardState` uses plural `filters` and singular `query`.
    const [extractedState, references] = (0, _common.extractReferences)({
      filter: searchSource.filters,
      query: searchSource.query
    });
    return {
      searchSourceJSON: JSON.stringify(extractedState),
      references
    };
  } catch (error) {
    // If the references can not be extracted, we log a warning
    // and return the original searchSource stringified.
    _kibana_services.logger.warn(`Unable to transform filter and query state on save. Error: ${error.message}`);
    return {
      searchSourceJSON: JSON.stringify(searchSource),
      references: []
    };
  }
}