"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.untilPluginStartServicesReady = exports.uiActionsEnhancedServices = exports.setKibanaServices = exports.coreServices = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let coreServices = exports.coreServices = void 0;
let uiActionsEnhancedServices = exports.uiActionsEnhancedServices = void 0;
const servicesReady$ = new _rxjs.BehaviorSubject(false);
const untilPluginStartServicesReady = () => {
  if (servicesReady$.value) return Promise.resolve();
  return new Promise(resolve => {
    const subscription = servicesReady$.subscribe(isInitialized => {
      if (isInitialized) {
        subscription.unsubscribe();
        resolve();
      }
    });
  });
};
exports.untilPluginStartServicesReady = untilPluginStartServicesReady;
const setKibanaServices = (kibanaCore, plugins) => {
  exports.coreServices = coreServices = kibanaCore;
  exports.uiActionsEnhancedServices = uiActionsEnhancedServices = plugins.uiActionsEnhanced;
  servicesReady$.next(true);
};
exports.setKibanaServices = setKibanaServices;