"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkVersionCompatibility = void 0;
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
var _constants = require("@kbn/core-saved-objects-base-server-internal/src/model_version/constants");
var _compare_mappings = require("../../core/compare_mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const checkVersionCompatibility = ({
  mappings,
  types,
  source,
  deletedTypes
}) => {
  const appVersions = (0, _coreSavedObjectsBaseServerInternal.getVirtualVersionMap)({
    types,
    useModelVersionsOnly: true
  });
  const indexVersions = (0, _coreSavedObjectsBaseServerInternal.getVirtualVersionsFromMappings)({
    mappings,
    source,
    knownTypes: types.map(type => type.name),
    minimumVirtualVersion: _constants.initialModelVersion
  });
  if (!indexVersions) {
    throw new Error(`Cannot check version: ${source} not present in the mapping meta`);
  }
  const updatedRootFields = (0, _compare_mappings.getUpdatedRootFields)(mappings);
  const modelVersionStatus = (0, _coreSavedObjectsBaseServerInternal.compareVirtualVersions)({
    appVersions,
    indexVersions,
    deletedTypes
  });
  const status = getCompatibilityStatus(modelVersionStatus.status, updatedRootFields.length > 0);
  return {
    status,
    updatedRootFields,
    versionDetails: modelVersionStatus.details
  };
};
exports.checkVersionCompatibility = checkVersionCompatibility;
const getCompatibilityStatus = (versionStatus, hasUpdatedRootFields) => {
  if (!hasUpdatedRootFields) {
    return versionStatus;
  }
  switch (versionStatus) {
    case 'lesser':
      // lower model versions but additional root mappings => conflict
      return 'conflict';
    case 'equal':
      // no change on model versions but additional root mappings => greater
      return 'greater';
    default:
      // greater and conflict are not impacted
      return versionStatus;
  }
};