"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHoverTimeout = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Hook for managing hover timeouts
 */
const useHoverTimeout = () => {
  const timeoutRef = (0, _react.useRef)(null);
  const clearTimeout = (0, _react.useCallback)(() => {
    if (timeoutRef.current) {
      window.clearTimeout(timeoutRef.current);
      timeoutRef.current = null;
    }
  }, []);
  const setTimeout = (0, _react.useCallback)((callback, delay) => {
    clearTimeout();
    timeoutRef.current = window.setTimeout(callback, delay);
  }, [clearTimeout]);
  (0, _react.useEffect)(() => clearTimeout, [clearTimeout]);
  return {
    setTimeout,
    clearTimeout
  };
};
exports.useHoverTimeout = useHoverTimeout;