"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrimaryMenuItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _side_nav = require("../side_nav");
var _use_nested_menu = require("./use_nested_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/nested_secondary_menu/primary_menu_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PrimaryMenuItem = ({
  id,
  children,
  hasSubmenu = false,
  isHighlighted = false,
  isCurrent,
  onClick,
  ...props
}) => {
  const {
    goToPanel
  } = (0, _use_nested_menu.useNestedMenu)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const handleClick = (0, _react.useCallback)(() => {
    if (hasSubmenu) {
      goToPanel(id, id);
    } else {
      onClick === null || onClick === void 0 ? void 0 : onClick();
    }
  }, [hasSubmenu, id, goToPanel, onClick]);
  const arrowStyle = (0, _react2.css)`
    opacity: 0.6;
    position: absolute;
    right: ${euiTheme.size.s};
    top: 50%;
    transform: translateY(-50%);
  `;
  const wrapperStyle = (0, _react2.css)`
    display: block;
    position: relative;
    width: 100%;
  `;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: wrapperStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.PrimaryMenuItem, (0, _extends2.default)({
    id: id,
    isHorizontal: true,
    isHighlighted: isHighlighted,
    isCurrent: isCurrent,
    onClick: handleClick
  }, props, {
    as: hasSubmenu ? 'button' : 'a',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }), children, hasSubmenu && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "text",
    css: arrowStyle,
    type: "arrowRight",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 24
    }
  })));
};
exports.PrimaryMenuItem = PrimaryMenuItem;