"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessMetricsCollector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _v = _interopRequireDefault(require("v8"));
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _register_otel_metrics = require("./register_otel_metrics");
var _event_loop_delays_monitor = require("./event_loop_delays_monitor");
var _event_loop_utilization_monitor = require("./event_loop_utilization_monitor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ProcessMetricsCollector {
  constructor() {
    (0, _defineProperty2.default)(this, "eventLoopDelayMonitor", new _event_loop_delays_monitor.EventLoopDelaysMonitor());
    (0, _defineProperty2.default)(this, "eventLoopUtilizationMonitor", new _event_loop_utilization_monitor.EventLoopUtilizationMonitor());
  }
  static getMainThreadMetrics(processes) {
    /**
     * Currently Kibana does not support multi-processes.
     * Once we have multiple processes we can add a `name` field
     * and filter on `name === 'server_worker'` to get the main thread.
     */
    return processes[0];
  }
  getCurrentPidMetrics() {
    const eventLoopDelayHistogram = this.eventLoopDelayMonitor.collect();
    const eventLoopUtilization = this.eventLoopUtilizationMonitor.collect();
    const heapStats = _v.default.getHeapStatistics();
    const memoryUsage = process.memoryUsage();
    return {
      memory: {
        heap: {
          total_in_bytes: memoryUsage.heapTotal,
          used_in_bytes: memoryUsage.heapUsed,
          size_limit: heapStats.heap_size_limit
        },
        resident_set_size_in_bytes: memoryUsage.rss,
        array_buffers_in_bytes: memoryUsage.arrayBuffers,
        external_in_bytes: memoryUsage.external
      },
      pid: process.pid,
      event_loop_delay: eventLoopDelayHistogram.max,
      event_loop_delay_histogram: eventLoopDelayHistogram,
      event_loop_utilization: eventLoopUtilization,
      uptime_in_millis: process.uptime() * 1000
    };
  }
  collect() {
    return [this.getCurrentPidMetrics()];
  }
  registerMetrics() {
    // (deprecated) Reporting metrics through APM
    _elasticApmNode.default.registerMetric('nodejs.memory.resident_set_size.bytes', () => process.memoryUsage().rss);
    _elasticApmNode.default.registerMetric('nodejs.heap.size_limit.bytes', () => _v.default.getHeapStatistics().heap_size_limit);

    // OTel Metrics
    (0, _register_otel_metrics.registerOtelMetrics)();
  }
  reset() {
    this.eventLoopDelayMonitor.reset();
    this.eventLoopUtilizationMonitor.reset();
  }
}
exports.ProcessMetricsCollector = ProcessMetricsCollector;