"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadCapabilites = loadCapabilites;
var _coreDiServer = require("@kbn/core-di-server");
var _coreDi = require("@kbn/core-di");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function loadCapabilites({
  bind,
  onActivation
}) {
  onActivation(_coreDiServer.CapabilitiesProvider, ({
    get
  }, provider) => {
    get((0, _coreDiServer.CoreSetup)('capabilities')).registerProvider(provider);
    return provider;
  });
  bind(_coreDi.OnSetup).toConstantValue(container => {
    container.getAll(_coreDiServer.CapabilitiesProvider);
  });
}