"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoreInjectionService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _inversify = require("inversify");
var _core = require("./modules/core");
var _plugin = require("./modules/plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */
class CoreInjectionService {
  constructor() {
    (0, _defineProperty2.default)(this, "root", new _inversify.Container(CoreInjectionService.DEFAULT_CONTAINER_OPTIONS));
    (0, _defineProperty2.default)(this, "module", new _plugin.PluginModule(this.root, CoreInjectionService.DEFAULT_CONTAINER_OPTIONS));
    this.fork = this.fork.bind(this);
    this.getContainer = this.getContainer.bind(this);
  }
  getContainer(id, container = this.root) {
    return container.get(_plugin.Scope)(id);
  }
  fork(id, container = this.root) {
    return container.get(_plugin.Fork)(id);
  }
  setup() {
    const contract = {
      getContainer: this.getContainer
    };
    this.root.loadSync(this.module);
    this.root.loadSync(_core.core);
    return contract;
  }
  start() {
    const contract = {
      fork: this.fork,
      getContainer: this.getContainer
    };
    return contract;
  }
}
exports.CoreInjectionService = CoreInjectionService;
(0, _defineProperty2.default)(CoreInjectionService, "DEFAULT_CONTAINER_OPTIONS", {
  autoBind: false,
  defaultScope: 'Singleton'
});