"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSortType = exports.getIpBuckets = exports.getEscapedWildcardQuery = exports.getEscapedRegexQuery = void 0;
var _lodash = require("lodash");
var _suggestions_sorting = require("../../../common/options_list/suggestions_sorting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getSortType = sort => {
  return sort ? {
    [sort.by]: sort.direction
  } : {
    [_suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT.by]: _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT.direction
  };
};
exports.getSortType = getSortType;
const getEscapedRegexQuery = (q = '') => q.replace(/[.?+*|{}[\]()"\\#@&<>~]/g, match => `\\${match}`);
exports.getEscapedRegexQuery = getEscapedRegexQuery;
const getEscapedWildcardQuery = (q = '') => q.replace(/[?*]/g, match => `\\${match}`);
exports.getEscapedWildcardQuery = getEscapedWildcardQuery;
const getIpBuckets = (rawEsResult, combinedBuckets, type) => {
  const results = (0, _lodash.get)(rawEsResult, `aggregations.suggestions.buckets.${type}.filteredSuggestions.buckets`);
  if (results) {
    results.forEach(suggestion => combinedBuckets.push(suggestion));
  }
};
exports.getIpBuckets = getIpBuckets;