"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValidationAggregationBuilder = void 0;
var _common = require("@kbn/data-views-plugin/common");
var _lodash = require("lodash");
var _options_list_selections = require("../../common/options_list/options_list_selections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Validation aggregations
 */
const getValidationAggregationBuilder = () => ({
  buildAggregation: ({
    selectedOptions,
    fieldName,
    fieldSpec
  }) => {
    var _selectedOptionsFilte;
    let selectedOptionsFilters;
    if (selectedOptions) {
      selectedOptionsFilters = selectedOptions.reduce((acc, currentOption) => {
        acc[currentOption] = {
          match: {
            [fieldName]: currentOption
          }
        };
        return acc;
      }, {});
    }
    if ((0, _lodash.isEmpty)((_selectedOptionsFilte = selectedOptionsFilters) !== null && _selectedOptionsFilte !== void 0 ? _selectedOptionsFilte : [])) {
      return {};
    }
    let validationAggregation = {
      validation: {
        filters: {
          filters: selectedOptionsFilters
        }
      }
    };
    const isNested = fieldSpec && (0, _common.getFieldSubtypeNested)(fieldSpec);
    if (isNested) {
      validationAggregation = {
        nestedValidation: {
          nested: {
            path: isNested.nested.path
          },
          aggs: {
            ...validationAggregation
          }
        }
      };
    }
    return validationAggregation;
  },
  parse: (rawEsResult, {
    fieldSpec
  }) => {
    if (!fieldSpec) return [];
    const isNested = fieldSpec && (0, _common.getFieldSubtypeNested)(fieldSpec);
    const rawInvalidSuggestions = (0, _lodash.get)(rawEsResult, isNested ? 'aggregations.nestedValidation.validation.buckets' : 'aggregations.validation.buckets');
    return rawInvalidSuggestions && !(0, _lodash.isEmpty)(rawInvalidSuggestions) ? Object.keys(rawInvalidSuggestions).filter(key => rawInvalidSuggestions[key].doc_count === 0).map(key => (0, _options_list_selections.getSelectionAsFieldType)(fieldSpec, key)) : [];
  }
});
exports.getValidationAggregationBuilder = getValidationAggregationBuilder;