"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.putConnectorFiltering = exports.ConnectorFilteringApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const putConnectorFiltering = async ({
  connectorId,
  http
}) => {
  const route = `/internal/content_connectors/connectors/${connectorId}/filtering`;
  return await (http === null || http === void 0 ? void 0 : http.put(route));
};
exports.putConnectorFiltering = putConnectorFiltering;
const ConnectorFilteringApiLogic = exports.ConnectorFilteringApiLogic = (0, _create_api_logic.createApiLogic)(['content', 'connector_filtering_api_logic'], putConnectorFiltering, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.filtering.successToastRules.title', {
    defaultMessage: 'Sync rules updated'
  })
});