"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _compare = _interopRequireDefault(require("semver/functions/compare"));
var _coerce = _interopRequireDefault(require("semver/functions/coerce"));
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _rules_states = require("../../../common/utils/rules_states");
var _rules_table = require("./rules_table");
var _rules_table_header = require("./rules_table_header");
var _use_csp_benchmark_rules = require("./use_csp_benchmark_rules");
var TEST_SUBJECTS = _interopRequireWildcard(require("./test_subjects"));
var _rules_flyout = require("./rules_flyout");
var _constants = require("../../common/constants");
var _use_page_size = require("../../common/hooks/use_page_size");
var _use_csp_rules_state = require("./use_csp_rules_state");
var _rules_counters = require("./rules_counters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/rules/rules_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getPage = (data, {
  page,
  perPage
}) => data.slice(page * perPage, (page + 1) * perPage);
const getRulesPageData = (data, status, error, query) => {
  const page = getPage(data, query);
  return {
    loading: status === 'loading',
    error: error ? (0, _cloudSecurityPostureCommon.extractErrorMessage)(error) : undefined,
    all_rules: data,
    rules_map: new Map(data.map(rule => [rule.metadata.id, rule])),
    rules_page: page,
    total: (data === null || data === void 0 ? void 0 : data.length) || 0
  };
};
const MAX_ITEMS_PER_PAGE = 10000;
const RulesContainer = () => {
  var _allRules$data2, _arrayRulesStates$fin, _allRules$data5, _allRules$data5$items;
  const params = (0, _reactRouterDom.useParams)();
  const history = (0, _reactRouterDom.useHistory)();
  const [enabledDisabledItemsFilter, setEnabledDisabledItemsFilter] = (0, _react.useState)('no-filter');
  const {
    pageSize,
    setPageSize
  } = (0, _use_page_size.usePageSize)(_constants.LOCAL_STORAGE_PAGE_SIZE_RULES_KEY);
  const navToRuleFlyout = ruleId => {
    history.push((0, _reactRouterDom.generatePath)(_cloudSecurityPosture.benchmarksNavigation.rules.path, {
      benchmarkVersion: params.benchmarkVersion,
      benchmarkId: params.benchmarkId,
      ruleId
    }));
  };
  const navToRulePage = () => {
    history.push((0, _reactRouterDom.generatePath)(_cloudSecurityPosture.benchmarksNavigation.rules.path, {
      benchmarkVersion: params.benchmarkVersion,
      benchmarkId: params.benchmarkId
    }));
  };

  // We need to make this call without filters. this way the section list is always full
  const allRules = (0, _use_csp_benchmark_rules.useFindCspBenchmarkRule)({
    page: 1,
    perPage: MAX_ITEMS_PER_PAGE,
    sortField: 'metadata.benchmark.rule_number',
    sortOrder: 'asc'
  }, params.benchmarkId, params.benchmarkVersion);
  const [rulesQuery, setRulesQuery] = (0, _react.useState)({
    section: undefined,
    ruleNumber: undefined,
    search: '',
    page: 0,
    perPage: pageSize || 10,
    sortField: 'metadata.benchmark.rule_number',
    sortOrder: 'asc'
  });

  // This useEffect is in charge of auto paginating to the correct page of a rule from the url params
  (0, _react.useEffect)(() => {
    const getPageByRuleId = () => {
      var _allRules$data;
      if (params.ruleId && (_allRules$data = allRules.data) !== null && _allRules$data !== void 0 && _allRules$data.items) {
        const ruleIndex = allRules.data.items.findIndex(rule => rule.metadata.id === params.ruleId);
        if (ruleIndex !== -1) {
          // Calculate the page based on the rule index and page size
          const rulePage = Math.floor(ruleIndex / pageSize);
          return rulePage;
        }
      }
      return 0;
    };
    setRulesQuery({
      ...rulesQuery,
      page: getPageByRuleId()
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [(_allRules$data2 = allRules.data) === null || _allRules$data2 === void 0 ? void 0 : _allRules$data2.items]);
  const {
    data,
    status,
    error
  } = (0, _use_csp_benchmark_rules.useFindCspBenchmarkRule)({
    section: rulesQuery.section,
    ruleNumber: rulesQuery.ruleNumber,
    search: rulesQuery.search,
    page: 1,
    perPage: MAX_ITEMS_PER_PAGE,
    sortField: 'metadata.benchmark.rule_number',
    sortOrder: rulesQuery.sortOrder
  }, params.benchmarkId, params.benchmarkVersion);
  const rulesStates = (0, _use_csp_rules_state.useCspGetRulesStates)();
  const arrayRulesStates = Object.values(rulesStates.data || {});
  const rulesWithStates = (0, _react.useMemo)(() => {
    if (!data) return [];
    return data.items.filter(rule => rule.metadata.benchmark.rule_number !== undefined).map(rule => {
      var _rulesStates$data;
      const rulesKey = (0, _rules_states.buildRuleKey)(rule.metadata.benchmark.id, rule.metadata.benchmark.version, /* Rule number always exists* from 8.7 */
      rule.metadata.benchmark.rule_number);
      const match = rulesStates === null || rulesStates === void 0 ? void 0 : (_rulesStates$data = rulesStates.data) === null || _rulesStates$data === void 0 ? void 0 : _rulesStates$data[rulesKey];
      const rulesState = match !== null && match !== void 0 && match.muted ? 'muted' : 'unmuted';
      return {
        ...rule,
        state: rulesState || 'unmuted'
      };
    });
  }, [data, rulesStates === null || rulesStates === void 0 ? void 0 : rulesStates.data]);
  const mutedRulesCount = rulesWithStates.filter(rule => rule.state === 'muted').length;
  const filteredRulesWithStates = (0, _react.useMemo)(() => {
    if (enabledDisabledItemsFilter === 'disabled') return rulesWithStates === null || rulesWithStates === void 0 ? void 0 : rulesWithStates.filter(rule => (rule === null || rule === void 0 ? void 0 : rule.state) === 'muted');else if (enabledDisabledItemsFilter === 'enabled') return rulesWithStates === null || rulesWithStates === void 0 ? void 0 : rulesWithStates.filter(rule => (rule === null || rule === void 0 ? void 0 : rule.state) === 'unmuted');else return rulesWithStates;
  }, [rulesWithStates, enabledDisabledItemsFilter]);
  const sectionList = (0, _react.useMemo)(() => {
    var _allRules$data3;
    return (_allRules$data3 = allRules.data) === null || _allRules$data3 === void 0 ? void 0 : _allRules$data3.items.map(rule => rule.metadata.section);
  }, [allRules.data]);
  const ruleNumberList = (0, _react.useMemo)(() => {
    var _allRules$data4;
    return (_allRules$data4 = allRules.data) === null || _allRules$data4 === void 0 ? void 0 : _allRules$data4.items.map(rule => rule.metadata.benchmark.rule_number || '');
  }, [allRules.data]);
  const cleanedSectionList = [...new Set(sectionList)].sort((a, b) => {
    return a.localeCompare(b, 'en', {
      sensitivity: 'base'
    });
  });
  const cleanedRuleNumberList = [...new Set(ruleNumberList)].sort((a, b) => {
    var _semVerCoerce, _semVerCoerce2;
    return (0, _compare.default)((_semVerCoerce = (0, _coerce.default)(a)) !== null && _semVerCoerce !== void 0 ? _semVerCoerce : '', (_semVerCoerce2 = (0, _coerce.default)(b)) !== null && _semVerCoerce2 !== void 0 ? _semVerCoerce2 : '');
  });
  const rulesPageData = (0, _react.useMemo)(() => getRulesPageData(filteredRulesWithStates, status, error, rulesQuery), [filteredRulesWithStates, status, error, rulesQuery]);
  const [selectedRules, setSelectedRules] = (0, _react.useState)([]);
  const setSelectAllRules = () => {
    setSelectedRules(rulesPageData.all_rules);
  };
  const rulesFlyoutData = {
    ...{
      state: ((_arrayRulesStates$fin = arrayRulesStates.find(filteredRuleState => filteredRuleState.rule_id === params.ruleId)) === null || _arrayRulesStates$fin === void 0 ? void 0 : _arrayRulesStates$fin.muted) === true ? 'muted' : 'unmuted'
    },
    ...{
      metadata: (_allRules$data5 = allRules.data) === null || _allRules$data5 === void 0 ? void 0 : (_allRules$data5$items = _allRules$data5.items.find(rule => rule.metadata.id === params.ruleId)) === null || _allRules$data5$items === void 0 ? void 0 : _allRules$data5$items.metadata
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": TEST_SUBJECTS.CSP_RULES_CONTAINER,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_rules_counters.RulesCounters, {
    mutedRulesCount: mutedRulesCount,
    setEnabledDisabledItemsFilter: setEnabledDisabledItemsFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_rules_table_header.RulesTableHeader, {
    onSectionChange: value => setRulesQuery(currentQuery => ({
      ...currentQuery,
      section: value
    })),
    onRuleNumberChange: value => setRulesQuery(currentQuery => ({
      ...currentQuery,
      ruleNumber: value
    })),
    sectionSelectOptions: cleanedSectionList,
    ruleNumberSelectOptions: cleanedRuleNumberList,
    search: value => setRulesQuery(currentQuery => ({
      ...currentQuery,
      search: value
    })),
    searchValue: rulesQuery.search || '',
    totalRulesCount: rulesPageData.all_rules.length,
    pageSize: rulesPageData.rules_page.length,
    isSearching: status === 'loading',
    selectedRules: selectedRules,
    setEnabledDisabledItemsFilter: setEnabledDisabledItemsFilter,
    enabledDisabledItemsFilterState: enabledDisabledItemsFilter,
    setSelectAllRules: setSelectAllRules,
    setSelectedRules: setSelectedRules,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_rules_table.RulesTable, {
    onSortChange: value => setRulesQuery(currentQuery => ({
      ...currentQuery,
      sortOrder: value
    })),
    rules_page: rulesPageData.rules_page,
    total: rulesPageData.total,
    error: rulesPageData.error,
    loading: rulesPageData.loading,
    perPage: pageSize || rulesQuery.perPage,
    page: rulesQuery.page,
    setPagination: paginationQuery => {
      setPageSize(paginationQuery.perPage);
      setRulesQuery(currentQuery => ({
        ...currentQuery,
        ...paginationQuery
      }));
    },
    selectedRuleId: params.ruleId,
    onRuleClick: navToRuleFlyout,
    selectedRules: selectedRules,
    setSelectedRules: setSelectedRules,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 7
    }
  }), params.ruleId && rulesFlyoutData.metadata && /*#__PURE__*/_react.default.createElement(_rules_flyout.RuleFlyout, {
    rule: rulesFlyoutData,
    onClose: navToRulePage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 9
    }
  }));
};
exports.RulesContainer = RulesContainer;