"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSafePostureTypeRuntimeMapping = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates the `safe_posture_type` runtime field with the value of either
 * `kspm` or `cspm` based on the value of `rule.benchmark.posture_type`
 */
const getSafePostureTypeRuntimeMapping = () => ({
  safe_posture_type: {
    type: 'keyword',
    script: {
      source: `
        def postureTypeAvailable = doc.containsKey("rule.benchmark.posture_type") && !doc["rule.benchmark.posture_type"].empty;
        boolean isNativeCsp = doc.containsKey("data_stream.dataset") && !doc["data_stream.dataset"].empty && doc["data_stream.dataset"].value == "cloud_security_posture.findings";

        if (isNativeCsp) {
          if (!postureTypeAvailable) {
            // Before 8.7 release
            emit("kspm");
          } else {
            emit(doc["rule.benchmark.posture_type"].value);
          }
        }
      `
    }
  }
});
exports.getSafePostureTypeRuntimeMapping = getSafePostureTypeRuntimeMapping;