"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetrySavedObjectsClient = void 0;
var _server = require("@kbn/core/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Extends the SavedObjectsClient to fit the telemetry fetching requirements (i.e.: find objects from all namespaces by default)
 */
class TelemetrySavedObjectsClient extends _server.SavedObjectsClient {
  /**
   * Find the SavedObjects matching the search query in all the Spaces by default
   * @param options
   */
  async find(options) {
    return super.find({
      namespaces: ['*'],
      ...options
    });
  }
}
exports.TelemetrySavedObjectsClient = TelemetrySavedObjectsClient;