"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHOWING_OBSERVABLES = exports.SELECT_OBSERVABLE_VALUE_PLACEHOLDER = exports.SELECT_OBSERVABLE_TYPE_PLACEHOLDER = exports.SELECT_OBSERVABLE_DESCRIPTION_PLACEHOLDER = exports.SEARCH_PLACEHOLDER = exports.SAVE_OBSERVABLE = exports.REQUIRED_VALUE = exports.PLATINUM_NOTICE = exports.OBSERVABLE_VALUE = exports.OBSERVABLE_TYPE = exports.OBSERVABLE_DESCRIPTION = exports.OBSERVABLE_ACTIONS = exports.OBSERVABLES_TABLE = exports.NO_OBSERVABLES = exports.IP = exports.INVALID_VALUE = exports.INVALID_EMAIL = exports.HOST_NAME = exports.FILE_PATH = exports.FILE_HASH = exports.FIELD_LABEL_VALUE = exports.FIELD_LABEL_TYPE = exports.FIELD_LABEL_DESCRIPTION = exports.EXTRACT_OBSERVABLES_LABEL = exports.EDIT_OBSERVABLE = exports.DOMAIN = exports.DELETE_OBSERVABLE_CONFIRM = exports.DELETE_OBSERVABLE = exports.DEFAULT_OBSERVABLE_TYPES_MODAL_DESCRIPTION = exports.DEFAULT_OBSERVABLE_TYPES_MODAL_BUTTON_ARIA_LABEL = exports.DATE_ADDED = exports.CANCEL = exports.AGENT_ID = exports.ADD_OBSERVABLE = exports.ADDED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_OBSERVABLE = exports.ADD_OBSERVABLE = _i18n.i18n.translate('xpack.cases.caseView.observables.addObservable', {
  defaultMessage: 'Add observable'
});
const EDIT_OBSERVABLE = exports.EDIT_OBSERVABLE = _i18n.i18n.translate('xpack.cases.caseView.observables.edit', {
  defaultMessage: 'Edit observable'
});
const NO_OBSERVABLES = exports.NO_OBSERVABLES = _i18n.i18n.translate('xpack.cases.caseView.observables.noObservablesAvailable', {
  defaultMessage: 'No observables available'
});
const SHOWING_OBSERVABLES = totalObservables => _i18n.i18n.translate('xpack.cases.caseView.observables.showingObservablesTitle', {
  values: {
    totalObservables
  },
  defaultMessage: 'Showing {totalObservables} {totalObservables, plural, =1 {observable} other {observables}}'
});
exports.SHOWING_OBSERVABLES = SHOWING_OBSERVABLES;
const OBSERVABLES_TABLE = exports.OBSERVABLES_TABLE = _i18n.i18n.translate('xpack.cases.caseView.observables.observablesTable', {
  defaultMessage: 'Observables table'
});
const SEARCH_PLACEHOLDER = exports.SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.cases.caseView.observables.searchPlaceholder', {
  defaultMessage: 'Search observables'
});
const DATE_ADDED = exports.DATE_ADDED = _i18n.i18n.translate('xpack.cases.caseView.observables.dateAdded', {
  defaultMessage: 'Date added'
});
const OBSERVABLE_TYPE = exports.OBSERVABLE_TYPE = _i18n.i18n.translate('xpack.cases.caseView.observables.type', {
  defaultMessage: 'Type'
});
const OBSERVABLE_VALUE = exports.OBSERVABLE_VALUE = _i18n.i18n.translate('xpack.cases.caseView.observables.value', {
  defaultMessage: 'Name'
});
const OBSERVABLE_DESCRIPTION = exports.OBSERVABLE_DESCRIPTION = _i18n.i18n.translate('xpack.cases.caseView.observables.description', {
  defaultMessage: 'Description'
});
const OBSERVABLE_ACTIONS = exports.OBSERVABLE_ACTIONS = _i18n.i18n.translate('xpack.cases.caseView.observables.actions', {
  defaultMessage: 'Actions'
});
const DELETE_OBSERVABLE = exports.DELETE_OBSERVABLE = _i18n.i18n.translate('xpack.cases.caseView.observables.delete', {
  defaultMessage: 'Delete observable'
});
const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.cases.caseView.observables.cancel', {
  defaultMessage: 'Cancel'
});
const SELECT_OBSERVABLE_VALUE_PLACEHOLDER = exports.SELECT_OBSERVABLE_VALUE_PLACEHOLDER = _i18n.i18n.translate('xpack.cases.caseView.observables.addObservableModal.selectValue', {
  defaultMessage: 'Enter value name'
});
const SELECT_OBSERVABLE_TYPE_PLACEHOLDER = exports.SELECT_OBSERVABLE_TYPE_PLACEHOLDER = _i18n.i18n.translate('xpack.cases.caseView.observables.addObservableModal.selectType', {
  defaultMessage: 'Select type'
});
const SELECT_OBSERVABLE_DESCRIPTION_PLACEHOLDER = exports.SELECT_OBSERVABLE_DESCRIPTION_PLACEHOLDER = _i18n.i18n.translate('xpack.cases.caseView.observables.addObservableModal.selectDescription', {
  defaultMessage: 'Provide additional information about the observable'
});
const DELETE_OBSERVABLE_CONFIRM = exports.DELETE_OBSERVABLE_CONFIRM = _i18n.i18n.translate('xpack.cases.caseView.observables.deleteConfirmation', {
  defaultMessage: 'Are you sure you want to delete this observable?'
});
const SAVE_OBSERVABLE = exports.SAVE_OBSERVABLE = _i18n.i18n.translate('xpack.cases.caseView.observables.save', {
  defaultMessage: 'Save observable'
});
const ADDED = (type, value) => _i18n.i18n.translate('xpack.cases.caseView.observables.added', {
  defaultMessage: 'observable value "{value}" of type {type} added',
  values: {
    type,
    value
  }
});
exports.ADDED = ADDED;
const PLATINUM_NOTICE = exports.PLATINUM_NOTICE = _i18n.i18n.translate('xpack.cases.caseView.observables.platinumNotice', {
  defaultMessage: 'In order to assign observables to cases, you must be subscribed to an Elastic Platinum license'
});
const REQUIRED_VALUE = exports.REQUIRED_VALUE = _i18n.i18n.translate('xpack.cases.caseView.observables.requiredValue', {
  defaultMessage: 'Value is required'
});
const INVALID_VALUE = exports.INVALID_VALUE = _i18n.i18n.translate('xpack.cases.caseView.observables.invalidValue', {
  defaultMessage: 'Value is invalid'
});
const INVALID_EMAIL = exports.INVALID_EMAIL = _i18n.i18n.translate('xpack.cases.caseView.observables.invalidEmail', {
  defaultMessage: 'Value should be a valid email'
});
const FIELD_LABEL_VALUE = exports.FIELD_LABEL_VALUE = _i18n.i18n.translate('xpack.cases.caseView.observables.labelValue', {
  defaultMessage: 'Value'
});
const FIELD_LABEL_DESCRIPTION = exports.FIELD_LABEL_DESCRIPTION = _i18n.i18n.translate('xpack.cases.caseView.observables.labelDescription', {
  defaultMessage: 'Description'
});
const FIELD_LABEL_TYPE = exports.FIELD_LABEL_TYPE = _i18n.i18n.translate('xpack.cases.caseView.observables.labelType', {
  defaultMessage: 'Type'
});
const EXTRACT_OBSERVABLES_LABEL = exports.EXTRACT_OBSERVABLES_LABEL = _i18n.i18n.translate('xpack.cases.caseView.observables.extractObservablesLabel', {
  defaultMessage: 'Auto-extract observables'
});
const AGENT_ID = exports.AGENT_ID = _i18n.i18n.translate('xpack.cases.caseView.observables.agentId', {
  defaultMessage: 'Agent id'
});
const HOST_NAME = exports.HOST_NAME = _i18n.i18n.translate('xpack.cases.caseView.observables.hostName', {
  defaultMessage: 'Host name'
});
const IP = exports.IP = _i18n.i18n.translate('xpack.cases.caseView.observables.ip', {
  defaultMessage: 'IP'
});
const FILE_PATH = exports.FILE_PATH = _i18n.i18n.translate('xpack.cases.caseView.observables.filePath', {
  defaultMessage: 'File path'
});
const FILE_HASH = exports.FILE_HASH = _i18n.i18n.translate('xpack.cases.caseView.observables.fileHash', {
  defaultMessage: 'File hash'
});
const DOMAIN = exports.DOMAIN = _i18n.i18n.translate('xpack.cases.caseView.observables.domain', {
  defaultMessage: 'Domain'
});
const DEFAULT_OBSERVABLE_TYPES_MODAL_BUTTON_ARIA_LABEL = exports.DEFAULT_OBSERVABLE_TYPES_MODAL_BUTTON_ARIA_LABEL = _i18n.i18n.translate('xpack.cases.caseView.observables.defaultObservableTypesModalButtonAriaLabel', {
  defaultMessage: 'Default observable types modal button'
});
const DEFAULT_OBSERVABLE_TYPES_MODAL_DESCRIPTION = exports.DEFAULT_OBSERVABLE_TYPES_MODAL_DESCRIPTION = _i18n.i18n.translate('xpack.cases.caseView.observables.defaultObservableTypesModalDescription', {
  defaultMessage: 'When auto-extract observables is on, available values from the following ECS fields are added as observables.'
});