"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Actions = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../case_view/translations"));
var _use_delete_cases = require("../../containers/use_delete_cases");
var _confirm_delete_case = require("../confirm_delete_case");
var _property_actions = require("../property_actions");
var _navigation = require("../../common/navigation");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_cases_toast = require("../../common/use_cases_toast");
var _types = require("../../client/attachment_framework/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/case_action_bar/actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionsComponent = ({
  caseData,
  currentExternalIncident
}) => {
  const {
    mutate: deleteCases
  } = (0, _use_delete_cases.useDeleteCases)();
  const {
    navigateToAllCases
  } = (0, _navigation.useAllCasesNavigation)();
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    showSuccessToast
  } = (0, _use_cases_toast.useCasesToast)();
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const buttonRef = _react.default.useRef(null);
  const openModal = (0, _react.useCallback)(() => {
    setIsModalVisible(true);
  }, []);
  const closeModal = (0, _react.useCallback)(() => {
    setIsModalVisible(false);
  }, []);
  const propertyActions = (0, _react.useMemo)(() => {
    var _currentExternalIncid;
    return [{
      type: _types.AttachmentActionType.BUTTON,
      iconType: 'copyClipboard',
      label: i18n.COPY_ID_ACTION_LABEL,
      onClick: () => {
        navigator.clipboard.writeText(caseData.id);
        showSuccessToast(i18n.COPY_ID_ACTION_SUCCESS);
      }
    }, ...(currentExternalIncident != null && !(0, _fp.isEmpty)(currentExternalIncident === null || currentExternalIncident === void 0 ? void 0 : currentExternalIncident.externalUrl) ? [{
      type: _types.AttachmentActionType.BUTTON,
      iconType: 'popout',
      label: i18n.VIEW_INCIDENT((_currentExternalIncid = currentExternalIncident === null || currentExternalIncident === void 0 ? void 0 : currentExternalIncident.externalTitle) !== null && _currentExternalIncid !== void 0 ? _currentExternalIncid : ''),
      onClick: () => window.open(currentExternalIncident === null || currentExternalIncident === void 0 ? void 0 : currentExternalIncident.externalUrl, '_blank')
    }] : []), ...(permissions.delete ? [{
      type: _types.AttachmentActionType.BUTTON,
      iconType: 'trash',
      label: i18n.DELETE_CASE(),
      color: 'danger',
      onClick: openModal
    }] : [])];
  }, [permissions.delete, openModal, currentExternalIncident, caseData.id, showSuccessToast]);
  const onConfirmDeletion = (0, _react.useCallback)(() => {
    setIsModalVisible(false);
    deleteCases({
      caseIds: [caseData.id],
      successToasterTitle: i18n.DELETED_CASES(1)
    }, {
      onSuccess: navigateToAllCases
    });
  }, [caseData.id, deleteCases, navigateToAllCases]);
  if (propertyActions.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "case-view-actions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_property_actions.PropertyActions, {
    propertyActions: propertyActions,
    customDataTestSubj: 'case',
    buttonRef: buttonRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), isModalVisible ? /*#__PURE__*/_react.default.createElement(_confirm_delete_case.ConfirmDeleteCaseModal, {
    totalCasesToBeDeleted: 1,
    onCancel: closeModal,
    onConfirm: onConfirmDeletion,
    focusButtonRef: buttonRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }) : null);
};
ActionsComponent.displayName = 'Actions';
const Actions = exports.Actions = /*#__PURE__*/_react.default.memo(ActionsComponent);