"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCreateCasePath = exports.getCasesConfigurePath = exports.getCaseViewWithCommentPath = exports.getCaseViewPath = exports.generateCaseViewPath = exports.DEFAULT_BASE_PATH = void 0;
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @kbn/eslint/module_migration

const DEFAULT_BASE_PATH = exports.DEFAULT_BASE_PATH = '/cases';
const normalizePath = path => path.replaceAll('//', '/');
const getCreateCasePath = casesBasePath => normalizePath(`${casesBasePath}${_constants.CASES_CREATE_PATH}`);
exports.getCreateCasePath = getCreateCasePath;
const getCasesConfigurePath = casesBasePath => normalizePath(`${casesBasePath}${_constants.CASES_CONFIGURE_PATH}`);
exports.getCasesConfigurePath = getCasesConfigurePath;
const getCaseViewPath = casesBasePath => normalizePath(`${casesBasePath}${_constants.CASE_VIEW_PATH}`);
exports.getCaseViewPath = getCaseViewPath;
const getCaseViewWithCommentPath = casesBasePath => normalizePath(`${casesBasePath}${_constants.CASE_VIEW_COMMENT_PATH}`);
exports.getCaseViewWithCommentPath = getCaseViewWithCommentPath;
const generateCaseViewPath = params => {
  const {
    commentId,
    tabId
  } = params;
  // paths with commentId have their own specific path.
  // Effectively overwrites the tabId
  if (commentId) {
    return normalizePath((0, _reactRouterDom.generatePath)(_constants.CASE_VIEW_COMMENT_PATH, params));
  }
  if (tabId !== undefined) {
    return normalizePath((0, _reactRouterDom.generatePath)(_constants.CASE_VIEW_TAB_PATH, params));
  }
  return normalizePath((0, _reactRouterDom.generatePath)(_constants.CASE_VIEW_PATH, params));
};
exports.generateCaseViewPath = generateCaseViewPath;