"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inFlightMiddlewareFactory = exports.inFlight = void 0;
var _loading_indicator = require("../../lib/loading_indicator");
var _modify_path = require("../../lib/modify_path");
var _resolved_args = require("../actions/resolved_args");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pathToKey = path => (0, _modify_path.convert)(path).join('/');
const inFlightMiddlewareFactory = ({
  loadingIndicator,
  pendingCache
}) => {
  return ({
    dispatch
  }) => next => {
    return action => {
      if (action.type === _resolved_args.setLoadingActionType) {
        const cacheKey = pathToKey(action.payload.path);
        pendingCache.push(cacheKey);
        dispatch((0, _resolved_args.inFlightActive)());
      } else if (action.type === _resolved_args.setValueActionType) {
        const cacheKey = pathToKey(action.payload.path);
        const idx = pendingCache.indexOf(cacheKey);
        if (idx >= 0) {
          pendingCache.splice(idx, 1);
        }
        if (pendingCache.length === 0) {
          dispatch((0, _resolved_args.inFlightComplete)());
        }
      } else if (action.type === _resolved_args.inFlightActiveActionType) {
        loadingIndicator.show();
      } else if (action.type === _resolved_args.inFlightCompleteActionType) {
        loadingIndicator.hide();
      }

      // execute the action
      next(action);
    };
  };
};
exports.inFlightMiddlewareFactory = inFlightMiddlewareFactory;
const inFlight = exports.inFlight = inFlightMiddlewareFactory({
  loadingIndicator: _loading_indicator.loadingIndicator,
  pendingCache: []
});