"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipIcon = exports.IconType = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/tooltip_icon/tooltip_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint react/forbid-elements: 0 */
let IconType = exports.IconType = /*#__PURE__*/function (IconType) {
  IconType["error"] = "error";
  IconType["warning"] = "warning";
  IconType["info"] = "info";
  return IconType;
}({});
const TooltipIcon = ({
  icon = IconType.info,
  ...rest
}) => {
  const icons = {
    [IconType.error]: {
      type: 'error',
      color: 'danger'
    },
    [IconType.warning]: {
      type: 'warning',
      color: 'warning'
    },
    [IconType.info]: {
      type: 'info',
      color: 'default'
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, (0, _extends2.default)({}, rest, {
    type: icons[icon].type,
    color: icons[icon].color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 10
    }
  }));
};
exports.TooltipIcon = TooltipIcon;
TooltipIcon.propTypes = {
  icon: _propTypes.default.string
};