"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleSummarizeQuery = handleSummarizeQuery;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleSummarizeQuery({
  state,
  model
}) {
  const outputParser = new _output_parsers.StringOutputParser();
  const celSummarizeGraph = _prompts.CEL_QUERY_SUMMARY_PROMPT.pipe(model).pipe(outputParser);
  const apiQuerySummary = await celSummarizeGraph.invoke({
    data_stream_name: state.dataStreamName,
    path: state.path,
    path_details: state.openApiPathDetails
  });
  return {
    apiQuerySummary,
    lastExecutedChain: 'summarizeQuery'
  };
}