"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIntegrationNameFromResponse = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Gets the integration name from the response.
 * First tries to get it from the _meta.name field, then falls back to parsing it from ingest pipeline names.
 * Since the integration name is not always returned in the response we have to parse it from the ingest pipeline name.
 * TODO: Return the package name from the fleet API: https://github.com/elastic/kibana/issues/185932
 */
const getIntegrationNameFromResponse = response => {
  var _response$_meta, _response$items$find$, _response$items, _response$items$find, _response$items$find$2, _response$items$find$3, _response$items$find$4;
  // First try to get the name from the _meta field
  if (response !== null && response !== void 0 && (_response$_meta = response._meta) !== null && _response$_meta !== void 0 && _response$_meta.name) {
    return response._meta.name;
  }

  // Fall back to parsing from ingest pipeline name (legacy behavior)
  return (_response$items$find$ = response === null || response === void 0 ? void 0 : (_response$items = response.items) === null || _response$items === void 0 ? void 0 : (_response$items$find = _response$items.find(item => item.type === 'ingest_pipeline')) === null || _response$items$find === void 0 ? void 0 : (_response$items$find$2 = _response$items$find.id) === null || _response$items$find$2 === void 0 ? void 0 : (_response$items$find$3 = _response$items$find$2.match(/^.*-([a-z\d_]+)\..*-([\d\.]+)\-*([a-z]*)$/)) === null || _response$items$find$3 === void 0 ? void 0 : (_response$items$find$4 = _response$items$find$3.slice(1, 3)) === null || _response$items$find$4 === void 0 ? void 0 : _response$items$find$4.join('-')) !== null && _response$items$find$ !== void 0 ? _response$items$find$ : '';
};
exports.getIntegrationNameFromResponse = getIntegrationNameFromResponse;