"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceMetadataIcons = getServiceMetadataIcons;
exports.should = void 0;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _elasticAgentUtils = require("@kbn/elastic-agent-utils");
var _maybe2 = require("../../../common/utils/maybe");
var _as_mutable_array = require("../../../common/utils/as_mutable_array");
var _apm = require("../../../common/es_fields/apm");
var _service_metadata = require("../../../common/service_metadata");
var _transactions = require("../../lib/helpers/transactions");
var _serverless = require("../../../common/serverless");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const should = exports.should = [{
  exists: {
    field: _apm.CONTAINER_ID
  }
}, {
  exists: {
    field: _apm.KUBERNETES_POD_NAME
  }
}, {
  exists: {
    field: _apm.CLOUD_PROVIDER
  }
}, {
  exists: {
    field: _apm.HOST_OS_PLATFORM
  }
}, {
  exists: {
    field: _apm.AGENT_NAME
  }
}, {
  exists: {
    field: _apm.AGENT_VERSION
  }
}, {
  exists: {
    field: _apm.SERVICE_FRAMEWORK_NAME
  }
}, {
  exists: {
    field: _apm.LABEL_TELEMETRY_AUTO_VERSION
  }
}];
async function getServiceMetadataIcons({
  serviceName,
  apmEventClient,
  searchAggregatedTransactions,
  start,
  end
}) {
  var _data$hits$hits$, _data$hits$hits$$fiel, _data$hits$hits$2, _data$hits$hits$2$fie, _data$hits$hits$3, _data$hits$hits$3$fie, _maybe, _cloud$service;
  const filter = [{
    term: {
      [_apm.SERVICE_NAME]: serviceName
    }
  }, ...(0, _server.rangeQuery)(start, end)];
  const fields = (0, _as_mutable_array.asMutableArray)([_apm.CLOUD_PROVIDER, _apm.CONTAINER_ID, _apm.AGENT_NAME, _apm.CLOUD_SERVICE_NAME, _apm.TELEMETRY_SDK_NAME, _apm.TELEMETRY_SDK_LANGUAGE, ..._service_metadata.SERVICE_METADATA_KUBERNETES_KEYS]);
  const params = {
    apm: {
      events: [(0, _transactions.getProcessorEventForTransactions)(searchAggregatedTransactions), _common.ProcessorEvent.error, _common.ProcessorEvent.metric]
    },
    track_total_hits: 1,
    size: 1,
    query: {
      bool: {
        filter,
        should
      }
    },
    fields
  };
  const data = await apmEventClient.search('get_service_metadata_icons', params);
  if (data.hits.total.value === 0) {
    return {
      agentName: undefined,
      containerType: undefined,
      cloudProvider: undefined,
      serverlessType: undefined
    };
  }
  const response = structuredClone(data);
  response.hits.hits[0].fields[_apm.AGENT_NAME] = (0, _elasticAgentUtils.getAgentName)((_data$hits$hits$ = data.hits.hits[0]) === null || _data$hits$hits$ === void 0 ? void 0 : (_data$hits$hits$$fiel = _data$hits$hits$.fields) === null || _data$hits$hits$$fiel === void 0 ? void 0 : _data$hits$hits$$fiel[_apm.AGENT_NAME], (_data$hits$hits$2 = data.hits.hits[0]) === null || _data$hits$hits$2 === void 0 ? void 0 : (_data$hits$hits$2$fie = _data$hits$hits$2.fields) === null || _data$hits$hits$2$fie === void 0 ? void 0 : _data$hits$hits$2$fie[_apm.TELEMETRY_SDK_LANGUAGE], (_data$hits$hits$3 = data.hits.hits[0]) === null || _data$hits$hits$3 === void 0 ? void 0 : (_data$hits$hits$3$fie = _data$hits$hits$3.fields) === null || _data$hits$hits$3$fie === void 0 ? void 0 : _data$hits$hits$3$fie[_apm.TELEMETRY_SDK_NAME]);
  const event = (0, _utils.unflattenKnownApmEventFields)((_maybe = (0, _maybe2.maybe)(response.hits.hits[0])) === null || _maybe === void 0 ? void 0 : _maybe.fields);
  const {
    kubernetes,
    cloud,
    container,
    agent
  } = event !== null && event !== void 0 ? event : {};
  let containerType;
  if (!!kubernetes) {
    containerType = 'Kubernetes';
  } else if (!!container) {
    containerType = 'Docker';
  }
  const serverlessType = (0, _serverless.getServerlessTypeFromCloudData)(cloud === null || cloud === void 0 ? void 0 : cloud.provider, cloud === null || cloud === void 0 ? void 0 : (_cloud$service = cloud.service) === null || _cloud$service === void 0 ? void 0 : _cloud$service.name);
  return {
    agentName: agent === null || agent === void 0 ? void 0 : agent.name,
    containerType,
    serverlessType,
    cloudProvider: cloud === null || cloud === void 0 ? void 0 : cloud.provider
  };
}