"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopDependencies = getTopDependencies;
var _server = require("@kbn/observability-plugin/server");
var _connections = require("../../../common/connections");
var _environment_query = require("../../../common/utils/environment_query");
var _get_connection_stats = require("../../lib/connections/get_connection_stats");
var _get_connection_stats_items_with_relative_impact = require("../../lib/connections/get_connection_stats/get_connection_stats_items_with_relative_impact");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getTopDependenciesForTimeRange({
  apmEventClient,
  start,
  end,
  numBuckets,
  environment,
  offset,
  kuery,
  randomSampler,
  withTimeseries
}) {
  const {
    statsItems,
    sampled
  } = await (0, _get_connection_stats.getConnectionStats)({
    apmEventClient,
    start,
    end,
    numBuckets,
    filter: [...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery)],
    offset,
    collapseBy: 'downstream',
    randomSampler,
    withTimeseries
  });
  return {
    stats: (0, _get_connection_stats_items_with_relative_impact.getConnectionStatsItemsWithRelativeImpact)(statsItems.filter(item => item.location.type !== _connections.NodeType.service)),
    sampled
  };
}
async function getTopDependencies(options) {
  const {
    offset,
    ...otherOptions
  } = options;
  const [currentDependencies, previousDependencies] = await Promise.all([getTopDependenciesForTimeRange(otherOptions), offset ? getTopDependenciesForTimeRange({
    ...otherOptions,
    offset
  }) : Promise.resolve([])]);
  return {
    dependencies: currentDependencies.stats.map(dependency => {
      var _prev$stats;
      const {
        stats,
        ...rest
      } = dependency;
      const prev = ('stats' in previousDependencies ? previousDependencies.stats : previousDependencies).find(item => item.location.id === dependency.location.id);
      return {
        ...rest,
        currentStats: stats,
        previousStats: (_prev$stats = prev === null || prev === void 0 ? void 0 : prev.stats) !== null && _prev$stats !== void 0 ? _prev$stats : null
      };
    }),
    sampled: currentDependencies.sampled
  };
}