"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dotnetVariables = exports.dotnetLineNumbers = exports.dotnetHighlightLang = exports.dotnet = void 0;
var _i18n = require("@kbn/i18n");
var _shared_hints = require("./shared_hints");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dotnetVariables = exports.dotnetVariables = {
  apmServiceName: 'ServiceName',
  secretToken: 'SecretToken',
  apmServerUrl: 'ServerUrl',
  apmEnvironment: 'Environment'
};
const dotnetHighlightLang = exports.dotnetHighlightLang = 'dotnet';
const dotnetServiceNameHint = _i18n.i18n.translate('xpack.apm.tutorial.dotnetClient.createConfig.commands.defaultServiceName', {
  defaultMessage: 'Default is the entry assembly of the application.'
});
const dotnetLineNumbers = exports.dotnetLineNumbers = {
  start: 1,
  highlight: '3, 4, 5, 6',
  annotations: {
    3: `${_shared_hints.serviceNameHint} ${dotnetServiceNameHint}`,
    4: _shared_hints.secretTokenHint,
    5: _shared_hints.serverUrlHint,
    6: _shared_hints.serviceEnvironmentHint
  }
};
const dotnet = exports.dotnet = `{
  "ElasticApm": {
    "${dotnetVariables.apmServiceName}": "{{{apmServiceName}}}",
    "${dotnetVariables.secretToken}": "{{{secretToken}}}",
    "${dotnetVariables.apmServerUrl}": "{{{apmServerUrl}}}",
    "${dotnetVariables.apmEnvironment}": "{{{apmEnvironment}}}",
  }
}`;