"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanMetadata = SpanMetadata;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _helper = require("../helper");
var _ = require("..");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/metadata_table/span_metadata/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SpanMetadata({
  span
}) {
  const {
    data: spanEvent,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/event_metadata/{processorEvent}/{id}', {
      params: {
        path: {
          processorEvent: _common.ProcessorEvent.span,
          id: span.span.id
        },
        query: {
          start: span['@timestamp'],
          end: span['@timestamp']
        }
      }
    });
  }, [span]);
  const sections = (0, _react.useMemo)(() => (0, _helper.getSectionsFromFields)((spanEvent === null || spanEvent === void 0 ? void 0 : spanEvent.metadata) || {}), [spanEvent === null || spanEvent === void 0 ? void 0 : spanEvent.metadata]);
  return /*#__PURE__*/_react.default.createElement(_.MetadataTable, {
    sections: sections,
    isLoading: status === _use_fetcher.FETCH_STATUS.LOADING,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 10
    }
  });
}