"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TreemapSelect = TreemapSelect;
exports.TreemapTypes = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/charts/mobile_most_affected/treemap_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let TreemapTypes = exports.TreemapTypes = /*#__PURE__*/function (TreemapTypes) {
  TreemapTypes["OsVersions"] = "osVersions";
  TreemapTypes["AppVersions"] = "appVersions";
  TreemapTypes["Devices"] = "devices";
  return TreemapTypes;
}({});
const options = [{
  value: TreemapTypes.Devices,
  label: _i18n.i18n.translate('xpack.apm.mobile.errorOverview.treemap.dropdown.devices', {
    defaultMessage: 'Devices'
  }),
  description: _i18n.i18n.translate('xpack.apm.mobile.errorOverview.treemap.dropdown.devices.subtitle', {
    defaultMessage: 'Treemap displaying the most affected devices.'
  })
}, {
  value: TreemapTypes.AppVersions,
  label: _i18n.i18n.translate('xpack.apm.mobile.errorOverview.treemap.versions.devices', {
    defaultMessage: 'App versions'
  }),
  description: _i18n.i18n.translate('xpack.apm.mobile.errorOverview.treemap.dropdown.versions.subtitle', {
    defaultMessage: 'Treemap displaying the most affected application versions.'
  })
}, {
  value: TreemapTypes.OsVersions,
  label: _i18n.i18n.translate('xpack.apm.mobile.errorOverview.treemap.dropdown.osVersions', {
    defaultMessage: 'OS versions'
  }),
  description: _i18n.i18n.translate('xpack.apm.mobile.errorOverview.treemap.dropdown.osVersions.subtitle', {
    defaultMessage: 'Treemap displaying the most affected OS versions.'
  })
}].map(({
  value,
  label,
  description
}) => ({
  inputDisplay: label,
  value,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, description)))
}));
function TreemapSelect({
  selectedTreemap,
  onChange
}) {
  var _options$find;
  const currentTreemap = (_options$find = options.find(({
    value
  }) => value === selectedTreemap)) !== null && _options$find !== void 0 ? _options$find : options[0];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.errorsOverview.treemap.title', {
    defaultMessage: 'Most affected {currentTreemap}',
    values: {
      currentTreemap: currentTreemap.value
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    style: {
      minWidth: '150px'
    },
    options: options,
    valueOfSelected: selectedTreemap,
    onChange: onChange,
    itemLayoutAlign: "top",
    hasDividers: true,
    "aria-label": _i18n.i18n.translate('xpack.apm.mobile.errorOverview.treemap.dropdown.ariaLabel', {
      defaultMessage: 'Treemap'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }))));
}