"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorDistribution = ErrorDistribution;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _chartsTheme = require("@kbn/charts-theme");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _use_previous_period_text = require("../../../../hooks/use_previous_period_text");
var _chart_container = require("../../../shared/charts/chart_container");
var _get_timeseries_color = require("../../../shared/charts/helper/get_timeseries_color");
var _timezone = require("../../../shared/charts/helper/timezone");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/error_group_details/distribution/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ErrorDistribution({
  distribution,
  title,
  fetchStatus
}) {
  var _distribution$current, _distribution$previou;
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const baseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    comparisonEnabled
  } = urlParams;
  const previousPeriodLabel = (0, _use_previous_period_text.usePreviousPeriodLabel)();
  const {
    currentPeriodColor,
    previousPeriodColor
  } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.ERROR_OCCURRENCES);
  const timeseries = [{
    data: (_distribution$current = distribution === null || distribution === void 0 ? void 0 : distribution.currentPeriod) !== null && _distribution$current !== void 0 ? _distribution$current : [],
    color: currentPeriodColor,
    title: _i18n.i18n.translate('xpack.apm.errorGroup.chart.ocurrences', {
      defaultMessage: 'Error occurrences'
    })
  }, ...(comparisonEnabled ? [{
    data: (_distribution$previou = distribution === null || distribution === void 0 ? void 0 : distribution.previousPeriod) !== null && _distribution$previou !== void 0 ? _distribution$previou : [],
    color: previousPeriodColor,
    title: previousPeriodLabel
  }] : [])];
  const xValues = timeseries.flatMap(({
    data
  }) => data.map(({
    x
  }) => x));
  const min = Math.min(...xValues);
  const max = Math.max(...xValues);
  const xFormatter = (0, _charts.niceTimeFormatter)([min, max]);
  const timeZone = (0, _timezone.getTimeZone)(core.uiSettings);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_chart_container.ChartContainer, {
    hasData: !!distribution,
    height: 256,
    status: fetchStatus,
    id: "errorDistribution",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    stickTo: "top",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    xDomain: {
      min,
      max
    },
    showLegend: true,
    legendValues: [_charts.LegendValue.CurrentAndLastValue],
    legendPosition: _charts.Position.Bottom,
    baseTheme: baseTheme,
    locale: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x-axis",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: xFormatter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y-axis",
    position: _charts.Position.Left,
    ticks: 2,
    gridLine: {
      visible: true
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }), timeseries.map(serie => {
    return /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
      timeZone: timeZone,
      key: serie.title,
      id: serie.title,
      minBarHeight: 2,
      xScaleType: _charts.ScaleType.Linear,
      yScaleType: _charts.ScaleType.Linear,
      xAccessor: "x",
      yAccessors: ['y'],
      data: serie.data,
      color: serie.color,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 15
      }
    });
  }))));
}