"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateSchedule = calculateSchedule;
var _constants = require("../../../common/constants");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getScheduleFromInterval = (start, interval, end) => {
  const schedule = [];
  const intervalInMs = (0, _common.parseDuration)(interval);
  let currentStart = new Date(start);
  let currentEnd;
  do {
    currentEnd = new Date(currentStart.valueOf() + intervalInMs);
    schedule.push({
      status: _constants.adHocRunStatus.PENDING,
      runAt: currentEnd.toISOString(),
      interval
    });
    currentStart = currentEnd;
  } while (end && currentEnd && currentEnd.valueOf() < new Date(end).valueOf());
  return schedule;
};
function calculateSchedule(interval, ranges) {
  return ranges.flatMap(range => {
    return getScheduleFromInterval(range.start, interval, range.end);
  });
}